/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor;

import io.github.noeppi_noeppi.libx.annotation.processor.Processor;
import io.github.noeppi_noeppi.libx.config.Config;
import io.github.noeppi_noeppi.libx.crafting.IngredientStack;
import io.github.noeppi_noeppi.libx.util.ResourceList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class ConfigProcessor
extends Processor {
    private Set<TypeMirror> validTypes;
    private Set<TypeMirror> validTypesWrapper;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        HashSet<TypeMirror> validTypes = new HashSet<TypeMirror>();
        validTypes.add(this.forClass(Boolean.TYPE));
        validTypes.add(this.forClass(Byte.TYPE));
        validTypes.add(this.forClass(Short.TYPE));
        validTypes.add(this.forClass(Integer.TYPE));
        validTypes.add(this.forClass(Long.TYPE));
        validTypes.add(this.forClass(Float.TYPE));
        validTypes.add(this.forClass(Double.TYPE));
        validTypes.add(this.forClass(String.class));
        validTypes.add(this.forClass(Optional.class));
        validTypes.add(this.forClass(List.class));
        validTypes.add(this.forClass(Map.class));
        validTypes.add(this.forClass(ResourceList.class));
        validTypes.add(this.forClass(IngredientStack.class));
        validTypes.add(this.forClass(UUID.class));
        this.addIfFound(validTypes, "net.minecraft.item.crafting.Ingredient");
        this.addIfFound(validTypes, "net.minecraft.util.text.IFormattableTextComponent");
        this.addIfFound(validTypes, "net.minecraft.util.ResourceLocation");
        this.validTypes = Collections.unmodifiableSet(validTypes);
        HashSet<TypeMirror> validTypesWrapper = new HashSet<TypeMirror>();
        validTypesWrapper.add(this.forClass(Boolean.class));
        validTypesWrapper.add(this.forClass(Byte.class));
        validTypesWrapper.add(this.forClass(Short.class));
        validTypesWrapper.add(this.forClass(Integer.class));
        validTypesWrapper.add(this.forClass(Long.class));
        validTypesWrapper.add(this.forClass(Float.class));
        validTypesWrapper.add(this.forClass(Double.class));
        this.validTypesWrapper = Collections.unmodifiableSet(validTypesWrapper);
    }

    @Override
    public Class<?>[] getTypes() {
        return new Class[]{Config.class};
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Config.class)) {
            TypeMirror elementType;
            TypeMirror typeClazz;
            TypeMirror keyClazz;
            Config config = element.getAnnotation(Config.class);
            if (this.isSuppressed(element, "config")) continue;
            if (element.getKind() != ElementKind.FIELD || !element.getModifiers().contains((Object)Modifier.STATIC) || !element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getModifiers().contains((Object)Modifier.FINAL)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Only public static non-final fields can be annotated with @Config", element);
                continue;
            }
            if (config.mapper().isEmpty()) {
                TypeMirror type = element.asType();
                if (this.validTypes.stream().noneMatch(t -> this.sameErasure((TypeMirror)t, type))) {
                    if (this.validTypesWrapper.stream().anyMatch(t -> this.sameErasure((TypeMirror)t, type))) {
                        this.messager.printMessage(Diagnostic.Kind.WARNING, "@Config should not use wrapper type: " + type, element);
                    } else {
                        Element typeElem = this.types.asElement(type);
                        if (typeElem == null || typeElem.getKind() != ElementKind.ENUM) {
                            this.messager.printMessage(Diagnostic.Kind.ERROR, "No value mapper found for type of @Config. Register you own." + type, element);
                        }
                    }
                }
            }
            if (element.asType() instanceof DeclaredType) {
                List<? extends TypeMirror> parameters = ((DeclaredType)element.asType()).getTypeArguments();
                if (parameters.isEmpty()) {
                    keyClazz = this.forClass(String.class);
                    typeClazz = this.forClass(Void.TYPE);
                } else {
                    keyClazz = parameters.get(0);
                    typeClazz = parameters.get(parameters.size() - 1);
                }
            } else {
                keyClazz = this.forClass(String.class);
                typeClazz = this.forClass(Void.TYPE);
            }
            if (!this.sameErasure(elementType = this.classType(config::elementType), typeClazz) && !this.isSuppressed(element, "unchecked")) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Unchecked @Config: elementType does not match type parameter.", element);
            } else if (elementType.getKind() != TypeKind.VOID && this.validTypes.stream().noneMatch(t -> this.sameErasure((TypeMirror)t, elementType)) && !this.isSuppressed(element, "configElement")) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Unchecked @Config: No value mapper for elementType. This is probably a bug.\nSuppress with @SuppressWarning(\"configElement\")", element);
            }
            if (!this.sameErasure(this.forClass(Map.class), element.asType()) || this.sameErasure(keyClazz, this.forClass(String.class)) || this.isSuppressed(element, "unchecked")) continue;
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Unchecked @Config: Map required keys of type String.", element);
        }
        return true;
    }

    private void addIfFound(Set<TypeMirror> types, String clazz) {
        TypeElement elem = this.elements.getTypeElement(clazz);
        if (elem != null && elem.asType() != null) {
            types.add(elem.asType());
        }
    }
}

