/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;

public class UppercaseEnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private final Class<T> enumClass;

    public static <R extends Enum<R>> UppercaseEnumArgument<R> enumArgument(Class<R> enumClass) {
        return new UppercaseEnumArgument<R>(enumClass);
    }

    private UppercaseEnumArgument(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public T parse(StringReader reader) {
        return Enum.valueOf(this.enumClass, reader.readUnquotedString().toUpperCase());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197013_a(Stream.of(this.enumClass.getEnumConstants()).map(Object::toString), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Stream.of(this.enumClass.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
    }

    public static class Serializer
    implements IArgumentSerializer<UppercaseEnumArgument<?>> {
        public void write(UppercaseEnumArgument argument, PacketBuffer buffer) {
            buffer.func_180714_a(argument.enumClass.getName());
        }

        @Nonnull
        public UppercaseEnumArgument read(PacketBuffer buffer) {
            String name = buffer.func_218666_n();
            try {
                return new UppercaseEnumArgument(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                System.err.println("Can't get enum value of type " + name + ". " + e.getMessage());
                return null;
            }
        }

        public void write(UppercaseEnumArgument argument, JsonObject json) {
            json.addProperty("enum", argument.enumClass.getName());
        }
    }
}

