/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;

public class IngredientStack
implements Predicate<ItemStack> {
    private final Ingredient ingredient;
    private final int count;

    public IngredientStack(Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = Math.max(count, 0);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public boolean test(ItemStack stack) {
        return stack.func_190916_E() >= this.count && this.ingredient.test(stack);
    }

    public boolean isEmpty() {
        return this.count == 0 || this.ingredient.func_203189_d();
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.add("Ingredient", this.ingredient.func_200304_c());
        json.addProperty("Count", (Number)this.count);
        return json;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.count);
        this.ingredient.func_199564_a(buffer);
    }

    public static IngredientStack deserialize(JsonObject json) {
        Ingredient ingredient = json.has("Ingredient") ? Ingredient.func_199802_a((JsonElement)json.get("Ingredient")) : Ingredient.field_193370_a;
        int count = json.has("Count") && json.get("Count").isJsonPrimitive() ? json.get("Count").getAsInt() : 0;
        return new IngredientStack(ingredient, count);
    }

    public static IngredientStack read(PacketBuffer buffer) {
        int count = buffer.func_150792_a();
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        return new IngredientStack(ingredient, count);
    }
}

