/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.commands;

import com.google.common.collect.Streams;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public class ModListCommand
implements Command<CommandSource> {
    private static final HoverEvent COPY_MODLIST = new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("libx.misc.copy_modlist"));
    public final boolean detailed;

    public ModListCommand(boolean detailed) {
        this.detailed = detailed;
    }

    public int run(CommandContext<CommandSource> context) {
        Stream<IFormattableTextComponent> lineStream = ModList.get().getMods().stream().sorted(Comparator.comparing(ModInfo::getDisplayName)).filter(mod -> !mod.getModId().equalsIgnoreCase("minecraft")).map(mod -> "" + mod.getDisplayName() + mod.getConfigElement(new String[]{"authors"}).map(a -> " (by " + a.toString().trim() + ")").orElse("") + (this.detailed && !mod.getDescription().trim().isEmpty() ? ": " + mod.getDescription().split("\n")[0].trim() : "")).map(StringTextComponent::new);
        List lines = Streams.mapWithIndex(lineStream, (line, idx) -> line.func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)(idx % 2L == 0L ? 0xFFFF00 : 0xFF00F6))))).map(line -> line.func_240703_c_(Style.field_240709_b_.func_240716_a_(COPY_MODLIST))).collect(Collectors.toList());
        String copyToClipboard = lines.stream().map(ITextComponent::getString).collect(Collectors.joining("\n"));
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, copyToClipboard);
        lines.stream().map(line -> line.func_240703_c_(Style.field_240709_b_.func_240715_a_(clickEvent))).forEach(line -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)line, false));
        return 0;
    }
}

