/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.network;

import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.impl.config.ConfigImpl;
import io.github.noeppi_noeppi.libx.impl.config.ConfigState;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ConfigShadowSerializer
implements PacketSerializer<ConfigShadowMessage> {
    @Override
    public Class<ConfigShadowMessage> messageClass() {
        return ConfigShadowMessage.class;
    }

    @Override
    public void encode(ConfigShadowMessage msg, PacketBuffer buffer) {
        buffer.func_192572_a(msg.config.id);
        PacketBuffer b = new PacketBuffer(Unpooled.buffer());
        msg.state.write(b);
        buffer.func_150787_b(b.writerIndex());
        buffer.writeBytes((ByteBuf)b);
    }

    @Override
    public ConfigShadowMessage decode(PacketBuffer buffer) {
        ResourceLocation configId = buffer.func_192575_l();
        ConfigImpl config = ConfigImpl.getConfigNullable(configId);
        int size = buffer.func_150792_a();
        if (config == null) {
            LibX.logger.warn("Received shadow message for unknown config: '" + configId + "'. Ignoring");
            buffer.skipBytes(size);
            return new ConfigShadowMessage(null, null);
        }
        if (config.clientConfig) {
            LibX.logger.warn("Received shadow message for not-synced config: '" + configId + "'. Ignoring");
            buffer.skipBytes(size);
            return new ConfigShadowMessage(null, null);
        }
        return new ConfigShadowMessage(config, config.readState(buffer));
    }

    public static class ConfigShadowMessage {
        public ConfigImpl config;
        public ConfigState state;

        public ConfigShadowMessage() {
        }

        public ConfigShadowMessage(ConfigImpl config, ConfigState state) {
            this.config = config;
            this.state = state;
        }
    }
}

