/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.mod.registration;

import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.BlockBase;
import java.lang.reflect.Constructor;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BlockTE<T extends TileEntity>
extends BlockBase {
    private final Class<T> teClass;
    private final Constructor<T> teConstructor;
    private final TileEntityType<T> teType;

    public BlockTE(ModX mod, Class<T> teClass, AbstractBlock.Properties properties) {
        this(mod, teClass, properties, new Item.Properties());
    }

    public BlockTE(ModX mod, Class<T> teClass, AbstractBlock.Properties properties, Item.Properties itemProperties) {
        super(mod, properties, itemProperties);
        this.teClass = teClass;
        try {
            this.teConstructor = teClass.getConstructor(TileEntityType.class);
        }
        catch (ReflectiveOperationException e) {
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            throw new RuntimeException("Could not get constructor for tile entity " + teClass + ".", e);
        }
        this.teType = new TileEntityType(() -> {
            try {
                return (TileEntity)this.teConstructor.newInstance(this.getTileType());
            }
            catch (ReflectiveOperationException e) {
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
                throw new RuntimeException("Could not create TileEntity of type " + teClass + ".", e);
            }
        }, (Set)ImmutableSet.of((Object)this), null);
    }

    @Override
    public Set<Object> getAdditionalRegisters() {
        return ImmutableSet.builder().addAll(super.getAdditionalRegisters()).add(this.teType).build();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public T createTileEntity(BlockState state, IBlockReader world) {
        return (T)this.teType.func_200968_a();
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        TileEntity te;
        if (!world.field_72995_K && this.shouldDropInventory(world, pos, state) && (te = world.func_175625_s(pos)) != null) {
            te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                if (handler instanceof IItemHandlerModifiable) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, stack.func_77946_l());
                        world.func_217376_c((Entity)entity);
                        ((IItemHandlerModifiable)handler).setStackInSlot(i, ItemStack.field_190927_a);
                    }
                }
            });
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public T getTile(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !this.teClass.isAssignableFrom(te.getClass())) {
            throw new IllegalStateException("Expected a tile entity of type " + this.teClass + " at " + world + " " + pos + ", got" + te);
        }
        return (T)te;
    }

    public TileEntityType<T> getTileType() {
        return this.teType;
    }

    protected boolean shouldDropInventory(World world, BlockPos pos, BlockState state) {
        return true;
    }
}

