/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraftforge.client.ForgeHooksClient;

public class RenderHelperItem {
    public static void renderItemTinted(ItemStack stack, ItemCameraTransforms.TransformType transformType, int light, int overlay, MatrixStack matrixStack, IRenderTypeBuffer buffer, float r, float g, float b, float alpha) {
        if (!stack.func_190926_b()) {
            boolean isGui = transformType == ItemCameraTransforms.TransformType.GUI;
            boolean isFixed = isGui || transformType == ItemCameraTransforms.TransformType.GROUND || transformType == ItemCameraTransforms.TransformType.FIXED;
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
            model = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStack, (IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)false);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            if (alpha < 1.0f) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (!model.func_188618_c() && (stack.func_77973_b() != Items.field_203184_eO || isFixed)) {
                RenderType type = RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)true);
                if (isGui && Objects.equals(type, Atlases.func_228785_j_())) {
                    type = Atlases.func_228785_j_();
                }
                if (alpha < 1.0f) {
                    if (Objects.equals(type, RenderType.func_228639_c_())) {
                        type = RenderType.func_228647_g_();
                    } else if (Objects.equals(type, RenderType.func_228643_e_())) {
                        type = RenderType.func_228641_d_();
                    } else if (Objects.equals(type, Atlases.func_228782_g_())) {
                        type = Atlases.func_228785_j_();
                    } else if (Objects.equals(type, Atlases.func_228783_h_())) {
                        type = Atlases.func_228785_j_();
                    }
                }
                IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)type, (boolean)true, (boolean)stack.func_77962_s());
                RenderHelperItem.renderTintedModel(model, stack, light, overlay, matrixStack, ivertexbuilder, r, g, b, alpha);
            } else {
                GlStateManager.func_227702_d_((float)r, (float)g, (float)b, (float)alpha);
                stack.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(stack, transformType, matrixStack, buffer, light, overlay);
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (alpha < 1.0f) {
                RenderSystem.disableBlend();
            }
            matrixStack.func_227865_b_();
        }
    }

    private static void renderTintedModel(IBakedModel model, ItemStack stack, int light, int overlay, MatrixStack matrixStack, IVertexBuilder buffer, float r, float g, float b, float alpha) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            RenderHelperItem.renderTintedQuads(matrixStack, buffer, model.func_200117_a(null, direction, random), stack, light, overlay, r, g, b, alpha);
        }
        random.setSeed(42L);
        RenderHelperItem.renderTintedQuads(matrixStack, buffer, model.func_200117_a(null, null, random), stack, light, overlay, r, g, b, alpha);
    }

    private static void renderTintedQuads(MatrixStack matrixStack, IVertexBuilder buffer, List<BakedQuad> quads, ItemStack stack, int light, int overlay, float r, float g, float b, float alpha) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        for (BakedQuad bakedquad : quads) {
            if (bakedquad.func_178212_b()) {
                int mixColor = Minecraft.func_71410_x().func_175599_af().field_184395_f.func_186728_a(stack, bakedquad.func_178211_c());
                float ir = (float)(mixColor >> 16 & 0xFF) / 255.0f;
                float ig = (float)(mixColor >> 8 & 0xFF) / 255.0f;
                float ib = (float)(mixColor & 0xFF) / 255.0f;
                buffer.addVertexData(entry, bakedquad, r * ir, g * ig, b * ib, alpha, light, overlay, true);
                continue;
            }
            buffer.addVertexData(entry, bakedquad, r, g, b, alpha, light, overlay, true);
        }
    }

    public static void renderItemGui(MatrixStack matrixStack, IRenderTypeBuffer buffer, ItemStack stack, int x, int y, int size, boolean includeAmount) {
        RenderHelperItem.renderItemGui(matrixStack, buffer, stack, x, y, size, includeAmount, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderItemGui(MatrixStack matrixStack, IRenderTypeBuffer buffer, ItemStack stack, int x, int y, int size, boolean includeAmount, float r, float g, float b, float alpha) {
        if (!stack.func_190926_b()) {
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, (LivingEntity)Minecraft.func_71410_x().field_71439_g);
            matrixStack.func_227860_a_();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            Minecraft.func_71410_x().func_110434_K().func_229267_b_(PlayerContainer.field_226615_c_).func_174937_a(false, false);
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.func_227861_a_((double)x, (double)y, 50.0);
            matrixStack.func_227862_a_((float)size / 16.0f, (float)size / 16.0f, 1.0f);
            matrixStack.func_227861_a_(8.0, 8.0, 0.0);
            matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
            matrixStack.func_227862_a_(16.0f, 16.0f, 16.0f);
            if (!model.func_230044_c_()) {
                RenderHelper.func_227783_c_();
            }
            RenderHelperItem.renderItemTinted(stack, ItemCameraTransforms.TransformType.GUI, 0xF000F0, OverlayTexture.field_229196_a_, matrixStack, buffer, r, g, b, alpha);
            ((IRenderTypeBuffer.Impl)buffer).func_228461_a_();
            RenderSystem.enableDepthTest();
            if (!model.func_230044_c_()) {
                RenderHelper.func_227784_d_();
            }
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
            matrixStack.func_227865_b_();
            if (includeAmount && stack.func_190916_E() > 1) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)x, (double)y, 90.0);
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                String text = Integer.toString(stack.func_190916_E());
                fr.func_228079_a_(text, (float)(17 - fr.func_78256_a(text)), 9.0f, 0xFFFFFF, true, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, 0xF000F0);
                matrixStack.func_227865_b_();
            }
        }
    }
}

