/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.config.Config;
import io.github.noeppi_noeppi.libx.config.ConfigValidator;
import io.github.noeppi_noeppi.libx.config.Group;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import io.github.noeppi_noeppi.libx.event.ConfigLoadedEvent;
import io.github.noeppi_noeppi.libx.impl.config.AdvancedValueMappers;
import io.github.noeppi_noeppi.libx.impl.config.ConfigImpl;
import io.github.noeppi_noeppi.libx.impl.config.ConfigState;
import io.github.noeppi_noeppi.libx.impl.config.EnumConfigMapper;
import io.github.noeppi_noeppi.libx.impl.config.SimpleValidators;
import io.github.noeppi_noeppi.libx.impl.config.SimpleValueMappers;
import io.github.noeppi_noeppi.libx.impl.network.ConfigShadowSerializer;
import io.github.noeppi_noeppi.libx.util.ClassUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.api.distmarker.OnlyIns;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigManager {
    private static final Map<Class<?>, ValueMapper<?, ?>> globalMappers = (Map)ImmutableSet.of(SimpleValueMappers.BOOLEAN, SimpleValueMappers.BYTE, SimpleValueMappers.SHORT, SimpleValueMappers.INTEGER, SimpleValueMappers.LONG, SimpleValueMappers.FLOAT, (Object[])new ValueMapper[]{SimpleValueMappers.DOUBLE, SimpleValueMappers.STRING, SimpleValueMappers.OPTION, SimpleValueMappers.LIST, SimpleValueMappers.MAP, AdvancedValueMappers.RESOURCE, AdvancedValueMappers.INGREDIENT, AdvancedValueMappers.TEXT_COMPONENT, AdvancedValueMappers.RESOURCE_LIST, AdvancedValueMappers.INGREDIENT_STACK, AdvancedValueMappers.UID}).stream().collect(ImmutableMap.toImmutableMap(ValueMapper::type, Function.identity()));
    private static final Map<Class<?>, ResourceLocation> globalMappersToRL = (Map)globalMappers.keySet().stream().map(key -> Pair.of((Object)key, (Object)new ResourceLocation("minecraft", ClassUtil.boxed(key).getSimpleName().toLowerCase(Locale.ROOT)))).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    private static final Map<ResourceLocation, ValueMapper<?, ?>> mappers = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<? extends Annotation>, ConfigValidator<?, ?>> globalValidators = (Map)ImmutableSet.of(SimpleValidators.SHORT, SimpleValidators.INTEGER, SimpleValidators.LONG, SimpleValidators.FLOAT, SimpleValidators.DOUBLE).stream().collect(ImmutableMap.toImmutableMap(ConfigValidator::annotation, Function.identity()));
    private static final Map<Class<? extends Annotation>, ConfigValidator<?, ?>> validators = Collections.synchronizedMap(new HashMap());
    private static final BiMap<ResourceLocation, Class<?>> configIds = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private static final Map<Class<?>, Path> configs = Collections.synchronizedMap(new HashMap());

    public static void registerValueMapper(ResourceLocation id, ValueMapper<?, ?> mapper) {
        if (mappers.containsKey(id)) {
            throw new IllegalStateException("Config mapper '" + id + "' is already registered.");
        }
        mappers.put(id, mapper);
    }

    public static ResourceLocation getMapperByAnnotationValue(String annotationValue, Class<?> typeClass) {
        if (annotationValue.isEmpty()) {
            Class<?> boxed = ClassUtil.boxed(typeClass);
            if (boxed.isEnum()) {
                return EnumConfigMapper.ID;
            }
            if (globalMappersToRL.containsKey(boxed)) {
                return globalMappersToRL.get(boxed);
            }
            if (typeClass != boxed) {
                throw new IllegalStateException("No builtin JSON mapper for type " + typeClass + " (" + boxed + "). You must provide one yourself.");
            }
            throw new IllegalStateException("No builtin JSON mapper for type " + typeClass + ". You must provide one yourself.");
        }
        return new ResourceLocation(annotationValue);
    }

    public static <T> ValueMapper<T, ?> getMapper(@Nullable ResourceLocation id, Class<T> fieldClass) {
        if (fieldClass == Void.TYPE) {
            throw new IllegalStateException("No mapper registered for void type. Probably the element type was omitted for a list or a map. If you are trying to create nested lists or maps, create a custom mapper.");
        }
        Class<?> boxed = ClassUtil.boxed(fieldClass);
        if (id == null) {
            if (boxed.isEnum()) {
                return EnumConfigMapper.getMapper(fieldClass);
            }
            if (globalMappers.containsKey(boxed)) {
                return globalMappers.get(boxed);
            }
            if (fieldClass != boxed) {
                throw new IllegalStateException("No builtin JSON mapper for type " + fieldClass + " (" + boxed + "). You must provide one yourself.");
            }
            throw new IllegalStateException("No builtin JSON mapper for type " + fieldClass + ". You must provide one yourself.");
        }
        if (EnumConfigMapper.ID.equals((Object)id)) {
            return EnumConfigMapper.getMapper(fieldClass);
        }
        if (mappers.containsKey(id)) {
            ValueMapper<?, ?> mapper = mappers.get(id);
            if (mapper.type() == boxed) {
                return mapper;
            }
            throw new IllegalStateException("Config mapper '" + id + "' can not be used on values of type " + fieldClass);
        }
        throw new IllegalStateException("No config mapper registered for id '" + id + "'.");
    }

    public static void registerConfigValidator(ConfigValidator<?, ?> validator) {
        if (validators.containsKey(validator.annotation())) {
            throw new IllegalStateException("Config validator '" + validator.annotation() + "' is already registered.");
        }
        validators.put(validator.annotation(), validator);
    }

    public static <A extends Annotation> ConfigValidator<?, A> getValidatorByAnnotation(Class<A> validatorClass) {
        if (Config.class.isAssignableFrom(validatorClass) || Group.class.isAssignableFrom(validatorClass) || OnlyIn.class.isAssignableFrom(validatorClass) || OnlyIns.class.isAssignableFrom(validatorClass)) {
            return null;
        }
        Optional<ConfigValidator> validator = globalValidators.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(validatorClass)).map(Map.Entry::getValue).findFirst();
        if (validator.isPresent()) {
            return validator.get();
        }
        validator = validators.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(validatorClass)).map(Map.Entry::getValue).findFirst();
        return validator.orElse(null);
    }

    public static void registerConfig(String modid, Class<?> configClass, boolean clientConfig) {
        ConfigManager.registerConfig(new ResourceLocation(modid, "config"), configClass, clientConfig);
    }

    public static void registerConfig(ResourceLocation location, Class<?> configClass, boolean clientConfig) {
        if (configIds.containsKey((Object)location)) {
            throw new IllegalArgumentException("Config '" + location + "' is already bound to class " + configClass);
        }
        if (configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + configClass + " is already registered as '" + configIds.inverse().get(configClass) + "'");
        }
        Path path = location.func_110623_a().equals("config") ? FMLPaths.GAMEDIR.get().resolve("config").resolve(location.func_110624_b() + ".json5") : FMLPaths.GAMEDIR.get().resolve("config").resolve(location.func_110624_b()).resolve(location.func_110623_a() + ".json5");
        configIds.put((Object)location, configClass);
        configs.put(configClass, path);
        new ConfigImpl(location, configClass, path, clientConfig);
        ConfigManager.firstLoadConfig(configClass);
    }

    public static void reloadAll() {
        for (Class<?> configClass : configs.keySet()) {
            ConfigManager.reloadConfig(configClass);
        }
    }

    private static void firstLoadConfig(Class<?> configClass) {
        if (!configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + configClass + " is not registered as a config.");
        }
        try {
            ConfigImpl config = ConfigImpl.getConfig((ResourceLocation)configIds.inverse().get(configClass));
            if (!config.clientConfig || FMLEnvironment.dist == Dist.CLIENT) {
                ConfigState defaultState = config.stateFromValues();
                config.setDefaultState(defaultState);
                ConfigState state = config.readFromFileOrCreateBy(defaultState);
                config.saveState(state);
                state.apply();
                MinecraftForge.EVENT_BUS.post((Event)new ConfigLoadedEvent(config.id, config.baseClass, ConfigLoadedEvent.LoadReason.INITIAL, config.clientConfig, config.path));
            }
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            LibX.logger.error("Failed to load config '" + configIds.inverse().get(configClass) + "' (class: " + configClass + ")", e);
        }
    }

    public static void reloadConfig(Class<?> configClass) {
        if (!configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + configClass + " is not registered as a config.");
        }
        try {
            ConfigImpl config = ConfigImpl.getConfig((ResourceLocation)configIds.inverse().get(configClass));
            if (!config.clientConfig || FMLEnvironment.dist == Dist.CLIENT) {
                ConfigState state = config.readFromFileOrCreateByDefault();
                config.saveState(state);
                if (!config.isShadowed()) {
                    state.apply();
                }
                MinecraftForge.EVENT_BUS.post((Event)new ConfigLoadedEvent(config.id, config.baseClass, ConfigLoadedEvent.LoadReason.RELOAD, config.clientConfig, config.path));
            }
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            LibX.logger.error("Failed to reload config '" + configIds.inverse().get(configClass) + "' (class: " + configClass + ")", e);
        }
    }

    public static void forceResync(@Nullable ServerPlayerEntity player, Class<?> configClass) {
        if (!configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + configClass + " is not registered as a config.");
        }
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            ResourceLocation id = (ResourceLocation)configIds.inverse().get(configClass);
            ConfigImpl config = ConfigImpl.getConfig(id);
            if (!config.clientConfig) {
                PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
                LibX.getNetwork().instance.send(target, (Object)new ConfigShadowSerializer.ConfigShadowMessage(config, config.cachedOrCurrent()));
            }
        } else {
            LibX.logger.error("ConfigManager.forceResync was called on a physical client. Ignoring.");
        }
    }

    public static void forceResync(@Nullable ServerPlayerEntity player) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            for (ResourceLocation id : ConfigManager.configs()) {
                ConfigImpl config = ConfigImpl.getConfig(id);
                if (config.clientConfig) continue;
                PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
                LibX.getNetwork().instance.send(target, (Object)new ConfigShadowSerializer.ConfigShadowMessage(config, config.cachedOrCurrent()));
            }
        } else {
            LibX.logger.error("ConfigManager.forceResync was called on a physical client. Ignoring.");
        }
    }

    public static Set<ResourceLocation> configs() {
        return Collections.unmodifiableSet(configIds.keySet());
    }

    static {
        globalMappers.forEach((key, value) -> ConfigManager.registerValueMapper(globalMappersToRL.get(key), value));
    }
}

