/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.mod;

import io.github.noeppi_noeppi.libx.mod.registration.ModXRegistration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ModX {
    public final String modid;
    public final Logger logger;
    public final ItemGroup tab;
    private final List<Runnable> setupTasks = new ArrayList<Runnable>();

    protected ModX(String modid, @Nullable ItemGroup tab) {
        this.modid = modid;
        this.logger = LogManager.getLogger((String)modid);
        this.tab = tab;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::runSetupTasks);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        if (!(this instanceof ModXRegistration)) {
            this.callGeneratedCode();
        }
    }

    private void runSetupTasks(FMLCommonSetupEvent event) {
        this.setupTasks.forEach(Runnable::run);
    }

    protected abstract void setup(FMLCommonSetupEvent var1);

    protected abstract void clientSetup(FMLClientSetupEvent var1);

    @Deprecated
    public final void addSetupTask(Runnable runnable) {
        StackTraceElement element;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length > 2 && !(element = stackTrace[2]).getClassName().startsWith("io.github.noeppi_noeppi.libx")) {
            this.logger.warn("ModX#addSetupTask was called from outside the library. You should override ModX#setup instead. This might fail in future versions. Caller was: " + element.getClassName() + " Please report to mod author.");
        }
        this.setupTasks.add(runnable);
    }

    protected final void callGeneratedCode() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(this.getClass().getCanonicalName() + "$");
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
            if (clazz != null) {
                Method method = clazz.getDeclaredMethod("init", ModX.class);
                method.invoke(null, this);
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Generated code threw an exception", e.getTargetException());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to load generated code", e);
        }
    }
}

