/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.impl;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import io.github.noeppi_noeppi.libx.util.LazyImmutableMap;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

public class ProcessorInterface {
    public static ResourceLocation newRL(String rl) {
        return new ResourceLocation(rl);
    }

    public static ResourceLocation newRL(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static <T> ResourceKey<Registry<T>> rootKey(ResourceLocation id) {
        return ResourceKey.m_135788_((ResourceLocation)id);
    }

    public static <T> MapCodec<Registry<T>> registryCodec(ResourceKey<Registry<T>> registry) {
        return RegistryLookupCodec.m_135622_(registry);
    }

    public static <T> ResourceKey<Registry<T>> getCodecDefaultRegistryKey(Class<?> clazz) {
        if (clazz.equals(DimensionType.class)) {
            return Registry.f_122818_;
        }
        if (clazz.equals(Biome.class)) {
            return Registry.f_122885_;
        }
        if (clazz.equals(ConfiguredSurfaceBuilder.class)) {
            return Registry.f_122879_;
        }
        if (clazz.equals(ConfiguredWorldCarver.class)) {
            return Registry.f_122880_;
        }
        if (clazz.equals(ConfiguredFeature.class)) {
            return Registry.f_122881_;
        }
        if (clazz.equals(ConfiguredStructureFeature.class)) {
            return Registry.f_122882_;
        }
        if (clazz.equals(StructureProcessorList.class)) {
            return Registry.f_122883_;
        }
        if (clazz.equals(StructureTemplatePool.class)) {
            return Registry.f_122884_;
        }
        if (clazz.equals(NoiseGeneratorSettings.class)) {
            return Registry.f_122878_;
        }
        throw new IllegalStateException("Failed to get registry codec key for type: " + clazz);
    }

    public static <T extends Event> void addModListener(Class<T> event, Consumer<T> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, event, listener);
    }

    public static <T extends Event> void addForgeListener(Class<T> event, Consumer<T> listener) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, event, listener);
    }

    public static void addDataProvider(GatherDataEvent event, DataProvider provider) {
        event.getGenerator().m_123914_(provider);
    }

    public static DataGenerator getDataGenerator(GatherDataEvent event) {
        return event.getGenerator();
    }

    public static ExistingFileHelper getDataFileHelper(GatherDataEvent event) {
        return event.getExistingFileHelper();
    }

    public static <K, V> LazyMapBuilder<K, V> lazyMapBuilder() {
        return new LazyMapBuilder();
    }

    public static class LazyMapBuilder<K, V> {
        private final ImmutableMap.Builder<K, LazyValue<V>> builder = ImmutableMap.builder();

        public void put(K k, Supplier<V> v) {
            this.builder.put(k, new LazyValue<V>(v));
        }

        public Map<K, V> build() {
            return new LazyImmutableMap(this.builder.build());
        }
    }
}

