/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor.modinit;

import io.github.noeppi_noeppi.libx.annotation.ForMod;
import io.github.noeppi_noeppi.libx.annotation.codec.Lookup;
import io.github.noeppi_noeppi.libx.annotation.codec.Param;
import io.github.noeppi_noeppi.libx.annotation.codec.PrimaryConstructor;
import io.github.noeppi_noeppi.libx.annotation.config.RegisterConfig;
import io.github.noeppi_noeppi.libx.annotation.config.RegisterMapper;
import io.github.noeppi_noeppi.libx.annotation.data.Datagen;
import io.github.noeppi_noeppi.libx.annotation.model.Model;
import io.github.noeppi_noeppi.libx.annotation.processor.Processor;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.FailureException;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.ModEnv;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.ModInit;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.CodecProcessor;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.config.RegisterConfigProcessor;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.config.RegisterMapperProcessor;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.data.DatagenProcessor;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.model.ModelProcessor;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.register.RegisterClassProcessor;
import io.github.noeppi_noeppi.libx.annotation.registration.NoReg;
import io.github.noeppi_noeppi.libx.annotation.registration.RegName;
import io.github.noeppi_noeppi.libx.annotation.registration.RegisterClass;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class ModInitProcessor
extends Processor
implements ModEnv {
    private final Map<String, ModInit> modInits = new HashMap<String, ModInit>();
    private String defaultModid = null;
    private Element defaultMod = null;

    @Override
    public Class<?>[] getTypes() {
        return new Class[]{ForMod.class, RegisterClass.class, NoReg.class, RegName.class, Model.class, RegisterConfig.class, RegisterMapper.class, PrimaryConstructor.class, Param.class, Lookup.class, Datagen.class};
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>(super.getSupportedAnnotationTypes());
        set.add("net.minecraftforge.fml.common.Mod");
        return set;
    }

    @Override
    public void run(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.modInits.clear();
        this.defaultModid = null;
        this.defaultMod = null;
        TypeElement modAnnotation = this.elements().getTypeElement("net.minecraftforge.fml.common.Mod");
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(modAnnotation);
        if (set.size() == 1) {
            Element elem = set.iterator().next();
            String modid = this.modidFromAnnotation(set.iterator().next());
            if (modid != null) {
                this.defaultModid = modid;
                this.defaultMod = elem;
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RegisterClass.class)) {
            try {
                RegisterClassProcessor.processRegisterClass(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Model.class)) {
            try {
                ModelProcessor.processModel(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RegisterMapper.class)) {
            try {
                RegisterMapperProcessor.processRegisterMapper(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RegisterConfig.class)) {
            try {
                RegisterConfigProcessor.processRegisterConfig(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Param.class)) {
            try {
                CodecProcessor.processAnyParam(element, "Param", this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Lookup.class)) {
            try {
                CodecProcessor.processAnyParam(element, "Lookup", this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(PrimaryConstructor.class)) {
            try {
                CodecProcessor.processPrimaryConstructor(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Datagen.class)) {
            try {
                DatagenProcessor.processDatagen(element, this);
            }
            catch (FailureException failureException) {}
        }
        for (ModInit modInit : this.modInits.values()) {
            modInit.write(this.filer(), this.messager());
        }
    }

    @Override
    public ModInit getMod(Element element) {
        return this.getMod(element, element);
    }

    private ModInit getMod(Element element, Element root) {
        PackageElement pkgElem;
        ForMod forMod = element.getAnnotation(ForMod.class);
        if (forMod != null) {
            TypeMirror modClass = this.classType(forMod::value);
            String modid = this.modidFromAnnotation(this.types().asElement(modClass));
            if (modid == null) {
                this.messager().printMessage(Diagnostic.Kind.ERROR, "Class used in @ForMod is not annotated with @Mod");
            }
            if (!this.modInits.containsKey(modid)) {
                this.modInits.put(modid, new ModInit(modid, this.types().asElement(modClass), this.messager()));
            }
            return this.modInits.get(modid);
        }
        if (element.getEnclosingElement() != null) {
            return this.getMod(element.getEnclosingElement(), root);
        }
        Element modClass = element;
        if (modClass instanceof PackageElement && !(pkgElem = (PackageElement)modClass).isUnnamed()) {
            String name = pkgElem.getQualifiedName().toString();
            if (!name.contains(".")) {
                return this.getMod(this.elements().getPackageElement(""), root);
            }
            return this.getMod(this.elements().getPackageElement(name.substring(0, name.lastIndexOf(46))), root);
        }
        if (this.defaultModid != null && this.defaultMod != null) {
            if (!this.modInits.containsKey(this.defaultModid)) {
                this.modInits.put(this.defaultModid, new ModInit(this.defaultModid, this.defaultMod, this.messager()));
            }
            return this.modInits.get(this.defaultModid);
        }
        this.messager().printMessage(Diagnostic.Kind.ERROR, "Could not infer modid for element. Use an @ForMod annotation.", root);
        return new ModInit("", this.types().asElement(this.forClass(ModX.class)), this.messager());
    }

    private String modidFromAnnotation(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.sameErasure(this.elements().getTypeElement("net.minecraftforge.fml.common.Mod").asType(), annotationMirror.getAnnotationType())) continue;
            return annotationMirror.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value")).findFirst().map(Map.Entry::getValue).map(v -> v.getValue().toString()).get();
        }
        return null;
    }
}

