/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.base;

import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class FluidBase
implements Registerable,
ItemLike {
    protected final ModX mod;
    private final Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceFactory;
    private final Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingFactory;
    private final UnaryOperator<FluidAttributes.Builder> attributes;
    private ForgeFlowingFluid.Source source;
    private ForgeFlowingFluid.Flowing flowing;
    private ForgeFlowingFluid.Properties properties;
    private final LiquidBlock block;
    private final BucketItem bucket;

    public FluidBase(ModX mod) {
        this(mod, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new, UnaryOperator.identity(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), FluidBase.defaultItemProperties(mod));
    }

    public FluidBase(ModX mod, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceFactory, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingFactory) {
        this(mod, sourceFactory, flowingFactory, UnaryOperator.identity(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), FluidBase.defaultItemProperties(mod));
    }

    public FluidBase(ModX mod, UnaryOperator<FluidAttributes.Builder> attributes) {
        this(mod, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new, attributes, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), FluidBase.defaultItemProperties(mod));
    }

    public FluidBase(ModX mod, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceFactory, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingFactory, UnaryOperator<FluidAttributes.Builder> attributes) {
        this(mod, sourceFactory, flowingFactory, attributes, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), FluidBase.defaultItemProperties(mod));
    }

    public FluidBase(ModX mod, Item.Properties itemProperties) {
        this(mod, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new, UnaryOperator.identity(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), itemProperties);
    }

    public FluidBase(ModX mod, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceFactory, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingFactory, Item.Properties itemProperties) {
        this(mod, sourceFactory, flowingFactory, UnaryOperator.identity(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), itemProperties);
    }

    public FluidBase(ModX mod, UnaryOperator<FluidAttributes.Builder> attributes, Item.Properties itemProperties) {
        this(mod, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new, attributes, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), itemProperties);
    }

    public FluidBase(ModX mod, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceFactory, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingFactory, UnaryOperator<FluidAttributes.Builder> attributes, Item.Properties itemProperties) {
        this(mod, sourceFactory, flowingFactory, attributes, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), itemProperties);
    }

    public FluidBase(ModX mod, BlockBehaviour.Properties blockProperties) {
        this(mod, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new, UnaryOperator.identity(), blockProperties, FluidBase.defaultItemProperties(mod));
    }

    public FluidBase(ModX mod, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceFactory, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingFactory, BlockBehaviour.Properties blockProperties) {
        this(mod, sourceFactory, flowingFactory, UnaryOperator.identity(), blockProperties, FluidBase.defaultItemProperties(mod));
    }

    public FluidBase(ModX mod, UnaryOperator<FluidAttributes.Builder> attributes, BlockBehaviour.Properties blockProperties) {
        this(mod, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new, attributes, blockProperties, FluidBase.defaultItemProperties(mod));
    }

    public FluidBase(ModX mod, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceFactory, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingFactory, UnaryOperator<FluidAttributes.Builder> attributes, BlockBehaviour.Properties blockProperties) {
        this(mod, sourceFactory, flowingFactory, attributes, blockProperties, FluidBase.defaultItemProperties(mod));
    }

    public FluidBase(ModX mod, BlockBehaviour.Properties blockProperties, Item.Properties itemProperties) {
        this(mod, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new, UnaryOperator.identity(), blockProperties, itemProperties);
    }

    public FluidBase(ModX mod, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceFactory, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingFactory, BlockBehaviour.Properties blockProperties, Item.Properties itemProperties) {
        this(mod, sourceFactory, flowingFactory, UnaryOperator.identity(), blockProperties, itemProperties);
    }

    public FluidBase(ModX mod, UnaryOperator<FluidAttributes.Builder> attributes, BlockBehaviour.Properties blockProperties, Item.Properties itemProperties) {
        this(mod, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new, attributes, blockProperties, itemProperties);
    }

    public FluidBase(ModX mod, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceFactory, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingFactory, UnaryOperator<FluidAttributes.Builder> attributes, BlockBehaviour.Properties blockProperties, Item.Properties itemProperties) {
        this.mod = mod;
        this.sourceFactory = sourceFactory;
        this.flowingFactory = flowingFactory;
        this.attributes = attributes;
        this.block = new LiquidBlock(this::getSource, blockProperties);
        this.bucket = new BucketItem(this::getSource, itemProperties.m_41487_(1)){

            public ItemStack getContainerItem(ItemStack stack) {
                return new ItemStack((ItemLike)Items.f_42446_);
            }

            @Nonnull
            protected String m_41467_() {
                return "libx.tooltip.fluidbase.bucket";
            }

            @Nonnull
            public Component m_7626_(@Nonnull ItemStack stack) {
                return new TranslatableComponent("libx.tooltip.fluidbase.bucket", new Object[]{FluidBase.this.getFluid().getAttributes().getDisplayName(new FluidStack(this.getFluid(), 1000))});
            }

            @Nonnull
            public Component m_41466_() {
                return new TranslatableComponent("libx.tooltip.fluidbase.bucket", new Object[]{FluidBase.this.getFluid().getAttributes().getDisplayName(new FluidStack(this.getFluid(), 1000))});
            }
        };
    }

    @Nonnull
    public Fluid getFluid() {
        return this.getSource();
    }

    @Nonnull
    public ForgeFlowingFluid.Source getSource() {
        return Objects.requireNonNull(this.source, "FluidBase has not yet been registered.");
    }

    @Nonnull
    public ForgeFlowingFluid.Flowing getFlowing() {
        return Objects.requireNonNull(this.flowing, "FluidBase has not yet been registered.");
    }

    @Nonnull
    public LiquidBlock getBlock() {
        return Objects.requireNonNull(this.block, "FluidBase has not yet been registered.");
    }

    @Nonnull
    public BucketItem getBucket() {
        return Objects.requireNonNull(this.bucket, "FluidBase has not yet been registered.");
    }

    @Nonnull
    public ForgeFlowingFluid.Properties getProperties() {
        return Objects.requireNonNull(this.properties, "FluidBase has not yet been registered.");
    }

    @Nonnull
    public Item m_5456_() {
        return this.getBucket();
    }

    @Override
    public Set<Object> getAdditionalRegisters(ResourceLocation id) {
        this.init(id);
        return Set.of(this.source, this.block);
    }

    @Override
    public Map<String, Object> getNamedAdditionalRegisters(ResourceLocation id) {
        this.init(id);
        return Map.of("flowing", this.flowing, "bucket", this.bucket);
    }

    private void init(ResourceLocation id) {
        if (this.properties == null) {
            FluidAttributes.Builder baseAttributes = FluidAttributes.builder((ResourceLocation)new ResourceLocation(id.m_135827_(), "block/" + id.m_135815_()), (ResourceLocation)new ResourceLocation(id.m_135827_(), "block/" + id.m_135815_()));
            baseAttributes.translationKey("fluid." + id.m_135827_() + "." + id.m_135815_());
            this.properties = new ForgeFlowingFluid.Properties(this::getSource, this::getFlowing, (FluidAttributes.Builder)this.attributes.apply(baseAttributes)).block(this::getBlock).bucket(this::getBucket);
            this.source = this.sourceFactory.apply(this.properties);
            this.flowing = this.flowingFactory.apply(this.properties);
        }
    }

    private static Item.Properties defaultItemProperties(ModX mod) {
        if (mod.tab != null) {
            return new Item.Properties().m_41491_(mod.tab);
        }
        return new Item.Properties();
    }
}

