/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import io.github.noeppi_noeppi.libx.impl.config.gui.screen.ConfigScreenManager;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.ScrollPanel;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ConfigBaseScreen
extends Screen {
    protected final Minecraft mc;
    @Nullable
    private final ConfigScreenManager manager;
    private final boolean hasSearchBar;
    @Nullable
    private EditBox searchBar;
    @Nullable
    private BasePanel panel;
    private final List<Pair<PoseStack.Pose, Runnable>> capturedTooltips = new LinkedList<Pair<PoseStack.Pose, Runnable>>();
    private boolean isCapturingTooltips = false;

    protected ConfigBaseScreen(Component title, @Nullable ConfigScreenManager manager, boolean hasSearchBar) {
        super(title);
        this.mc = Minecraft.m_91087_();
        this.manager = manager;
        this.hasSearchBar = hasSearchBar;
    }

    protected void m_7856_() {
        if (this.manager != null) {
            Button back = new Button(5, 5, 42, 20, (Component)new TextComponent("\u2190 ").m_7220_((Component)new TranslatableComponent("libx.config.gui.back")), button -> this.manager.close());
            this.m_142416_((GuiEventListener)back);
        }
        if (this.hasSearchBar) {
            boolean shouldFocus = this.searchBar != null && this.searchBar.m_93696_();
            boolean isActive = this.searchBar != null && this.m_7222_() == this.searchBar;
            Font font = this.mc.f_91062_;
            Objects.requireNonNull(this.mc.f_91062_);
            this.searchBar = new EditBox(font, 20, 18 + 9, this.f_96543_ - 40, 20, this.searchBar, (Component)new TranslatableComponent("libx.config.gui.search.title"));
            this.searchBar.m_94199_(Short.MAX_VALUE);
            this.searchBar.m_94178_(shouldFocus);
            this.m_142416_((GuiEventListener)this.searchBar);
            if (isActive) {
                this.m_7522_((GuiEventListener)this.searchBar);
            }
            this.searchBar.m_94151_(this::searchChange);
        } else {
            this.searchBar = null;
        }
        this.rebuild();
    }

    protected void rebuild() {
        if (this.panel != null) {
            this.m_169411_((GuiEventListener)this.panel);
        }
        ImmutableList.Builder widgetBuilder = ImmutableList.builder();
        this.buildGui(arg_0 -> ((ImmutableList.Builder)widgetBuilder).add(arg_0));
        ImmutableList widgets = widgetBuilder.build();
        final int totalHeight = 10 + widgets.stream().map(w -> w.f_93621_ + w.m_93694_()).max(Comparator.naturalOrder()).orElse(0);
        Objects.requireNonNull(this.mc.f_91062_);
        int paddingTop = 18 + 9 + (this.hasSearchBar ? 26 : 0);
        this.panel = new BasePanel(this.mc, this.f_96543_ - 2, this.f_96544_ - paddingTop, paddingTop, 1, (List)widgets){
            final /* synthetic */ List val$widgets;
            {
                this.val$widgets = list;
                super(mc, width, height, top, left);
            }

            protected int getContentHeight() {
                return totalHeight;
            }

            public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
                ConfigBaseScreen.this.isCapturingTooltips = true;
                super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                ConfigBaseScreen.this.isCapturingTooltips = false;
                ConfigBaseScreen.this.capturedTooltips.forEach(pair -> {
                    poseStack.m_85836_();
                    poseStack.m_166856_();
                    poseStack.m_166854_(((PoseStack.Pose)pair.getLeft()).m_85861_());
                    ((Runnable)pair.getRight()).run();
                    poseStack.m_85849_();
                });
                ConfigBaseScreen.this.capturedTooltips.clear();
            }

            protected void drawPanel(PoseStack poseStack, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, (double)relativeY, 0.0);
                for (AbstractWidget widget : this.val$widgets) {
                    widget.m_6305_(poseStack, mouseX, mouseY - relativeY, ConfigBaseScreen.this.mc.m_91297_());
                }
                poseStack.m_85849_();
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (mouseX >= (double)this.left && mouseX <= (double)(this.left + this.width) && mouseY >= (double)this.top && mouseY <= (double)(this.top + this.height)) {
                    return super.m_6375_(mouseX, mouseY, button);
                }
                return false;
            }

            protected boolean clickPanel(double mouseX, double mouseY, int button) {
                boolean success = false;
                for (GuiEventListener widget : this.val$widgets) {
                    if (!widget.m_6375_(mouseX, mouseY, button)) continue;
                    this.m_7522_(widget);
                    if (button == 0) {
                        this.m_7897_(true);
                    }
                    success = true;
                }
                return success;
            }

            public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
                if (!super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
                    if (this.m_7222_() != null && this.m_7282_() && button == 0) {
                        GuiEventListener guiEventListener = this.m_7222_();
                        double d = mouseY - (double)this.top + (double)((int)this.scrollDistance);
                        Objects.requireNonNull(this);
                        return guiEventListener.m_7979_(mouseX, d - 4.0, button, dragX, dragY);
                    }
                    return false;
                }
                return true;
            }

            public boolean m_6348_(double mouseX, double mouseY, int button) {
                if (!super.m_6348_(mouseX, mouseY, button)) {
                    if (this.m_7222_() != null) {
                        GuiEventListener guiEventListener = this.m_7222_();
                        double d = mouseY - (double)this.top + (double)((int)this.scrollDistance);
                        Objects.requireNonNull(this);
                        return guiEventListener.m_6348_(mouseX, d - 4.0, button);
                    }
                    return false;
                }
                return true;
            }
        };
        this.m_142416_((GuiEventListener)this.panel);
    }

    protected abstract void buildGui(Consumer<AbstractWidget> var1);

    @Nullable
    public ConfigScreenManager getCurrentManager() {
        return this.manager;
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.mc.f_91062_.m_92763_(poseStack, this.m_96636_(), (float)((this.f_96543_ - this.mc.f_91062_.m_92852_((FormattedText)this.m_96636_())) / 2), 12.0f, 0xFFFFFF);
    }

    public boolean m_7933_(int key, int i1, int i2) {
        if (key == 256 && this.m_6913_() && this.manager != null) {
            this.manager.close();
            return true;
        }
        return super.m_7933_(key, i1, i2);
    }

    public String searchTerm() {
        return this.searchBar == null ? "" : this.searchBar.m_94155_();
    }

    protected void searchChange(String term) {
    }

    private void captureTooltip(PoseStack.Pose pose, Runnable action) {
        this.capturedTooltips.add((Pair<PoseStack.Pose, Runnable>)Pair.of((Object)pose, (Object)action));
    }

    protected void m_6057_(@Nonnull PoseStack poseStack, @Nonnull ItemStack stack, int mouseX, int mouseY) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.m_6057_(poseStack, stack, mouseX, mouseY));
        } else {
            super.m_6057_(poseStack, stack, mouseX, mouseY);
        }
    }

    public void renderTooltip(@Nonnull PoseStack poseStack, @Nonnull List<Component> components, @Nonnull Optional<TooltipComponent> special, int x, int y, @Nonnull ItemStack stack) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderTooltip(poseStack, components, special, x, y, stack));
        } else {
            super.renderTooltip(poseStack, components, special, x, y, stack);
        }
    }

    public void renderTooltip(@Nonnull PoseStack poseStack, @Nonnull List<Component> components, @Nonnull Optional<TooltipComponent> special, int x, int y, @Nullable Font font) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderTooltip(poseStack, components, special, x, y, font));
        } else {
            super.renderTooltip(poseStack, components, special, x, y, font);
        }
    }

    public void renderTooltip(@Nonnull PoseStack poseStack, @Nonnull List<Component> components, @Nonnull Optional<TooltipComponent> special, int x, int y, @Nullable Font font, @Nonnull ItemStack stack) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderTooltip(poseStack, components, special, x, y, font, stack));
        } else {
            super.renderTooltip(poseStack, components, special, x, y, font, stack);
        }
    }

    public void m_169388_(@Nonnull PoseStack poseStack, @Nonnull List<Component> components, @Nonnull Optional<TooltipComponent> special, int mouseX, int mouseY) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.m_169388_(poseStack, components, special, mouseX, mouseY));
        } else {
            super.m_169388_(poseStack, components, special, mouseX, mouseY);
        }
    }

    public void m_96602_(@Nonnull PoseStack poseStack, @Nonnull Component component, int mouseX, int mouseY) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.m_96602_(poseStack, component, mouseX, mouseY));
        } else {
            super.m_96602_(poseStack, component, mouseX, mouseY);
        }
    }

    public void m_96597_(@Nonnull PoseStack poseStack, @Nonnull List<Component> components, int mouseX, int mouseY) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.m_96597_(poseStack, components, mouseX, mouseY));
        } else {
            super.m_96597_(poseStack, components, mouseX, mouseY);
        }
    }

    public void renderComponentTooltip(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedText> components, int mouseX, int mouseY, @Nonnull ItemStack stack) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderComponentTooltip(poseStack, components, mouseX, mouseY, stack));
        } else {
            super.renderComponentTooltip(poseStack, components, mouseX, mouseY, stack);
        }
    }

    public void renderComponentTooltip(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedText> components, int mouseX, int mouseY, @Nullable Font font) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderComponentTooltip(poseStack, components, mouseX, mouseY, font));
        } else {
            super.renderComponentTooltip(poseStack, components, mouseX, mouseY, font);
        }
    }

    public void renderComponentTooltip(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedText> components, int mouseX, int mouseY, @Nullable Font font, @Nonnull ItemStack stack) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderComponentTooltip(poseStack, components, mouseX, mouseY, font, stack));
        } else {
            super.renderComponentTooltip(poseStack, components, mouseX, mouseY, font, stack);
        }
    }

    public void m_96617_(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedCharSequence> components, int mouseX, int mouseY) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.m_96617_(poseStack, components, mouseX, mouseY));
        } else {
            super.m_96617_(poseStack, components, mouseX, mouseY);
        }
    }

    public void renderTooltip(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedCharSequence> components, int x, int y, @Nonnull Font font) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderTooltip(poseStack, components, x, y, font));
        } else {
            super.renderTooltip(poseStack, components, x, y, font);
        }
    }

    private static abstract class BasePanel
    extends ScrollPanel
    implements NarratableEntry {
        public BasePanel(Minecraft mc, int width, int height, int top, int left) {
            super(mc, width, height, top, left);
        }

        @Nonnull
        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(@Nonnull NarrationElementOutput output) {
        }
    }
}

