/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.data.texture;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;

public class TextureGenerator {
    private final String modid;
    private final DataGenerator generator;
    private final ExistingFileHelper fileHelper;

    public TextureGenerator(String modid, DataGenerator generator, ExistingFileHelper fileHelper) {
        this.modid = modid;
        this.generator = generator;
        this.fileHelper = fileHelper;
    }

    public void save(HashCache cache, ResourceLocation id, BufferedImage image) {
        Path path = this.generator.m_123916_().resolve("assets").resolve(id.m_135827_()).resolve(id.m_135815_());
        this.save(cache, image, path);
    }

    public void save(HashCache cache, BufferedImage image, Path path) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", byteOut);
            byte[] data = byteOut.toByteArray();
            String hash = DataProvider.f_123918_.hashBytes(data).toString();
            if (!Objects.equals(cache.m_123938_(path), hash) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                out.write(data);
                out.close();
                cache.m_123940_(path, hash);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save generated texture: " + path);
        }
    }

    public BufferedImage newImage(int width, int height, int scale) {
        return new BufferedImage(width * scale, height * scale, 2);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public BufferedImage loadImage(ResourceLocation image) {
        if (!this.fileHelper.exists(image, PackType.CLIENT_RESOURCES)) {
            throw new RuntimeException("Texture does not exists: " + image);
        }
        try (Resource res = this.fileHelper.getResource(image, PackType.CLIENT_RESOURCES);){
            BufferedImage bufferedImage;
            block15: {
                InputStream in = res.m_6679_();
                try {
                    bufferedImage = ImageIO.read(in);
                    if (in == null) break block15;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return bufferedImage;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load texture: " + image, e);
        }
    }
}

