/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class JsonToText {
    private static final HoverEvent COPY_JSON = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("libx.misc.copy_json"));

    public static MutableComponent toText(JsonElement element) {
        Style copyTag = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, element.toString())).m_131144_(COPY_JSON);
        return JsonToText.toTextInternal(element).m_130948_(copyTag);
    }

    private static MutableComponent toTextInternal(JsonElement element) {
        if (element.isJsonNull()) {
            return new TextComponent("");
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return new TextComponent(primitive.getAsBoolean() ? "true" : "false").m_130940_(ChatFormatting.GOLD);
            }
            if (primitive.isNumber()) {
                return new TextComponent(primitive.getAsNumber().toString()).m_130940_(ChatFormatting.GOLD);
            }
            if (primitive.isString()) {
                return new TextComponent("\"").m_7220_((Component)new TextComponent(JsonToText.escape(primitive.getAsString())).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent("\""));
            }
            return JsonToText.toTextInternal((JsonElement)primitive);
        }
        if (element.isJsonArray()) {
            TextComponent tc = new TextComponent("[");
            boolean first = true;
            for (JsonElement entry : element.getAsJsonArray()) {
                if (first) {
                    first = false;
                } else {
                    tc.m_7220_((Component)new TextComponent(", "));
                }
                tc = tc.m_7220_((Component)JsonToText.toTextInternal(entry));
            }
            tc = tc.m_7220_((Component)new TextComponent("]"));
            return tc;
        }
        if (element.isJsonObject()) {
            TextComponent tc = new TextComponent("{");
            boolean first = true;
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    tc.m_7220_((Component)new TextComponent(", "));
                }
                tc = tc.m_7220_((Component)new TextComponent("\"").m_7220_((Component)new TextComponent((String)entry.getKey()).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)new TextComponent("\""))).m_7220_((Component)new TextComponent(": ")).m_7220_((Component)JsonToText.toTextInternal((JsonElement)entry.getValue()));
            }
            tc = tc.m_7220_((Component)new TextComponent("}"));
            return tc;
        }
        throw new IllegalArgumentException("JSON type unknown: " + element.getClass());
    }

    private static String escape(String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\\n").replace("\t", "\\\t").replace("\r", "\\\r").replace("\u0000", "\\\u0000").replace("\f", "\\\f");
    }
}

