/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.entity;

import com.feywild.feywild.block.entity.mana.CapabilityMana;
import com.feywild.feywild.block.entity.mana.IManaStorage;
import com.feywild.feywild.block.entity.mana.ManaStorage;
import com.feywild.feywild.item.ModItems;
import com.feywild.feywild.recipes.IDwarvenAnvilRecipe;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.feywild.feywild.tag.ModItemTags;
import com.feywild.feywild.util.StreamUtil;
import io.github.noeppi_noeppi.libx.base.tile.BlockEntityBase;
import io.github.noeppi_noeppi.libx.base.tile.TickableBlock;
import io.github.noeppi_noeppi.libx.capability.ItemCapabilities;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class DwarvenAnvil
extends BlockEntityBase
implements TickableBlock {
    public static final int MAX_MANA = 1000;
    public static final int FEY_DUST_MANA_COST = 50;
    private final BaseItemStackHandler inventory = BaseItemStackHandler.builder((int)8).contentsChanged(() -> {
        this.m_6596_();
        this.updateRecipe();
    }).validator(stack -> stack.m_41720_() == ModItems.feyDust, new int[]{0}).validator(stack -> ModItemTags.SCHEMATICS.m_8110_((Object)stack.m_41720_()), new int[]{1}).validator(stack -> this.f_58857_ == null || RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), ModRecipeTypes.DWARVEN_ANVIL, (ItemStack)stack), new int[]{2, 3, 4, 5, 6}).validator(stack -> false, new int[]{7}).build();
    private final ManaStorage manaStorage = new ManaStorage(1000, () -> {
        this.m_6596_();
        this.updateRecipe();
    });
    private final LazyOptional<IAdvancedItemHandlerModifiable> itemHandlerGeneric = ItemCapabilities.create(() -> this.inventory);
    private final LazyOptional<IAdvancedItemHandlerModifiable> itemHandlerTop = ItemCapabilities.create(() -> this.inventory, slot -> false, (slot, stack) -> slot >= 2 && slot < 7);
    private final LazyOptional<IAdvancedItemHandlerModifiable> itemHandlerSide = ItemCapabilities.create(() -> this.inventory, slot -> false, (slot, stack) -> slot < 2);
    private final LazyOptional<IAdvancedItemHandlerModifiable> itemHandlerBottom = ItemCapabilities.create(() -> this.inventory, slot -> slot == 7, (slot, stack) -> false);
    private final LazyOptional<IManaStorage> manaHandler = LazyOptional.of(() -> this.manaStorage);
    private boolean needsUpdate = false;
    private LazyValue<Optional<Pair<ItemStack, IDwarvenAnvilRecipe>>> recipe = new LazyValue(Optional::empty);

    public DwarvenAnvil(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_7651_() {
        super.m_7651_();
        this.itemHandlerTop.invalidate();
        this.itemHandlerSide.invalidate();
        this.itemHandlerBottom.invalidate();
        this.manaHandler.invalidate();
    }

    public void tick() {
        if (this.f_58857_ != null && this.f_58857_ instanceof ServerLevel) {
            ItemStack extracted;
            if (this.needsUpdate) {
                this.updateRecipe();
                this.needsUpdate = false;
            }
            if (((ServerLevel)this.f_58857_).m_142572_().m_129921_() % 20 == 0 && this.manaStorage.getMana() + 50 <= this.manaStorage.getMaxMana() && !(extracted = this.inventory.extractItem(0, 1, true)).m_41619_() && extracted.m_41720_() == ModItems.feyDust) {
                this.inventory.extractItem(0, 1, false);
                this.manaStorage.receiveMana(50, false);
                this.m_6596_();
            }
        }
    }

    @Nonnull
    public CompoundTag m_6945_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128365_("mana", (Tag)this.manaStorage.serializeNBT());
        return super.m_6945_(nbt);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        this.manaStorage.deserializeNBT(nbt.m_128469_("mana"));
        this.needsUpdate = true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.itemHandlerGeneric.cast();
            }
            return switch (side) {
                case Direction.UP -> this.itemHandlerTop.cast();
                case Direction.DOWN -> this.itemHandlerBottom.cast();
                default -> this.itemHandlerSide.cast();
            };
        }
        if (capability == CapabilityMana.MANA) {
            return this.manaHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void craft() {
        ((Optional)this.recipe.get()).ifPresent(pair -> {
            ItemStack result = (ItemStack)pair.getLeft();
            IDwarvenAnvilRecipe recipe = (IDwarvenAnvilRecipe)pair.getRight();
            this.manaStorage.extractMana(recipe.getMana(), false);
            IntStream.range(2, 7).forEach(slot -> this.inventory.extractItem(slot, 1, false));
            this.inventory.getUnrestricted().insertItem(7, result.m_41777_(), false);
        });
    }

    private void updateRecipe() {
        this.recipe = this.f_58857_ == null || this.f_58857_.f_46443_ ? new LazyValue(Optional::empty) : new LazyValue(() -> {
            ItemStack schematics = this.inventory.getStackInSlot(1);
            List inputs = IntStream.range(2, 7).mapToObj(arg_0 -> ((BaseItemStackHandler)this.inventory).getStackInSlot(arg_0)).filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
            return this.f_58857_.m_7465_().m_44013_(ModRecipeTypes.DWARVEN_ANVIL).stream().flatMap(r -> StreamUtil.zipOption(r.getResult(schematics, inputs), r)).findFirst().filter(p -> ((IDwarvenAnvilRecipe)p.getRight()).getMana() <= this.manaStorage.getMana()).filter(p -> this.inventory.getUnrestricted().insertItem(7, (ItemStack)p.getLeft(), true).m_41619_());
        });
    }

    public boolean canCraft() {
        return ((Optional)this.recipe.get()).isPresent();
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getMana() {
        return this.manaStorage.getMana();
    }

    public void setMana(int mana) {
        this.manaStorage.setMana(mana);
    }
}

