/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.entity;

import com.feywild.feywild.recipes.IAltarRecipe;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.feywild.feywild.util.StreamUtil;
import io.github.noeppi_noeppi.libx.base.tile.BlockEntityBase;
import io.github.noeppi_noeppi.libx.base.tile.TickableBlock;
import io.github.noeppi_noeppi.libx.capability.ItemCapabilities;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class FeyAltar
extends BlockEntityBase
implements TickableBlock,
IAnimatable {
    public static final int MAX_PROGRESS = 40;
    private final BaseItemStackHandler inventory;
    private int progress = 0;
    private int particleTimer = 0;
    private boolean needsUpdate = false;
    private LazyValue<Optional<Pair<ItemStack, IAltarRecipe>>> recipe = new LazyValue(Optional::empty);
    private final LazyOptional<IAdvancedItemHandlerModifiable> itemHandler;
    private final AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);

    public FeyAltar(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = BaseItemStackHandler.builder((int)5).contentsChanged(() -> {
            this.m_6596_();
            this.updabeRecipe();
            this.setDispatchable();
        }).defaultSlotLimit(1).build();
        this.itemHandler = ItemCapabilities.create(() -> this.inventory);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.needsUpdate) {
                this.updabeRecipe();
                this.needsUpdate = false;
            }
            if (((Optional)this.recipe.get()).isPresent()) {
                Pair currentRecipe = (Pair)((Optional)this.recipe.get()).get();
                ++this.progress;
                if (this.progress >= 40) {
                    for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                        this.inventory.setStackInSlot(slot, ItemStack.f_41583_);
                    }
                    ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)(this.f_58858_.m_123342_() + 2), (double)this.f_58858_.m_123343_() + 0.5, ((ItemStack)currentRecipe.getLeft()).m_41777_());
                    this.f_58857_.m_7967_((Entity)entity);
                    this.progress = 0;
                }
                this.m_6596_();
                this.setDispatchable();
            } else {
                this.progress = 0;
            }
        } else if (this.progress > 0) {
            if (this.progress >= 39) {
                for (int i = 0; i < 20; ++i) {
                    this.f_58857_.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.2, (double)this.f_58858_.m_123343_() + 0.5, 0.5 - this.f_58857_.f_46441_.nextDouble(), 0.7 - this.f_58857_.f_46441_.nextDouble(), 0.5 - this.f_58857_.f_46441_.nextDouble());
                }
                this.progress = 0;
            } else {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int slot = 0; slot < this.getInventory().getSlots(); ++slot) {
                    ItemStack stack = this.getInventory().getStackInSlot(slot);
                    if (stack.m_41619_()) continue;
                    stacks.add(stack);
                }
                if (!stacks.isEmpty()) {
                    double progressScaled = (double)this.progress / 40.0;
                    double anglePerStack = Math.PI * 2 / (double)stacks.size();
                    for (int idx = 0; idx < stacks.size(); ++idx) {
                        double shiftX = Math.cos((double)this.f_58857_.m_46467_() / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                        double shiftZ = Math.sin((double)this.f_58857_.m_46467_() / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                        this.f_58857_.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, (double)this.f_58858_.m_123341_() + 0.5 + shiftX, (double)(this.f_58858_.m_123342_() + 1) + progressScaled, (double)this.f_58858_.m_123343_() + 0.5 + shiftZ, 0.0, 0.0, 0.0);
                    }
                }
            }
        } else if (this.particleTimer <= 0) {
            this.particleTimer = this.f_58857_.f_46441_.nextInt(120);
            if ((double)this.f_58857_.f_46441_.nextFloat() < 0.5) {
                this.f_58857_.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.nextDouble(), (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.nextDouble(), (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void updabeRecipe() {
        this.recipe = this.f_58857_ != null && !this.f_58857_.f_46443_ ? new LazyValue(() -> {
            List inputs = IntStream.range(0, this.inventory.getSlots()).mapToObj(arg_0 -> ((BaseItemStackHandler)this.inventory).getStackInSlot(arg_0)).filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
            return this.f_58857_.m_7465_().m_44013_(ModRecipeTypes.ALTAR).stream().flatMap(r -> StreamUtil.zipOption(r.getResult(inputs), r)).findFirst();
        }) : new LazyValue(Optional::empty);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getProgress() {
        return this.progress;
    }

    @Nonnull
    public CompoundTag m_6945_(@Nonnull CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("progress", this.progress);
        return super.m_6945_(nbt);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("progress");
        this.needsUpdate = true;
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            nbt.m_128405_("progress", this.progress);
        }
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.progress = nbt.m_128451_("progress");
        }
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.altar.motion", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }
}

