/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.data.recipe;

import com.feywild.feywild.data.DataUtils;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.noeppi_noeppi.libx.data.provider.recipe.RecipeExtension;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public interface AltarExtension
extends RecipeExtension {
    default public AltarRecipeBuilder altar(ItemLike result) {
        return this.altar(new ItemStack(result));
    }

    default public AltarRecipeBuilder altar(ItemLike result, int amount) {
        return this.altar(new ItemStack(result, amount));
    }

    default public AltarRecipeBuilder altar(ItemStack result) {
        return new AltarRecipeBuilder(this, result);
    }

    public static class AltarRecipeBuilder {
        private final RecipeExtension ext;
        private final ItemStack result;
        private final List<Ingredient> inputs;

        public AltarRecipeBuilder(RecipeExtension ext, ItemStack result) {
            this.ext = ext;
            this.result = result;
            this.inputs = new ArrayList<Ingredient>();
        }

        public AltarRecipeBuilder requires(ItemLike item) {
            return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }

        public AltarRecipeBuilder requires(Tag<Item> item) {
            return this.requires(Ingredient.m_43911_(item));
        }

        public AltarRecipeBuilder requires(Ingredient item) {
            this.inputs.add(item);
            return this;
        }

        public void build() {
            this.build(this.ext.provider().loc((ItemLike)this.result.m_41720_(), "fey_altar"));
        }

        public void build(final ResourceLocation id) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Can't build fey altar recipe without inputs: " + id);
            }
            if (this.inputs.size() > 5) {
                throw new IllegalStateException("Can't build fey altar recipe with more than 5 inputs: " + id);
            }
            this.ext.consumer().accept(new FinishedRecipe(){

                public void m_7917_(@Nonnull JsonObject json) {
                    json.add("output", (JsonElement)DataUtils.serializeWithNbt(result));
                    JsonArray inputList = new JsonArray();
                    inputs.forEach(i -> inputList.add(i.m_43942_()));
                    json.add("ingredients", (JsonElement)inputList);
                }

                @Nonnull
                public ResourceLocation m_6445_() {
                    return id;
                }

                @Nonnull
                public RecipeSerializer<?> m_6637_() {
                    return ModRecipeTypes.ALTAR_SERIALIZER;
                }

                @Nullable
                public JsonObject m_5860_() {
                    return null;
                }

                @Nullable
                public ResourceLocation m_6448_() {
                    return null;
                }
            });
        }
    }
}

