/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity;

import com.feywild.feywild.config.MobConfig;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.entity.base.FeyBase;
import com.feywild.feywild.entity.goals.BeeRestrictAttackGoal;
import com.feywild.feywild.entity.goals.FeyAttackableTargetGoal;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.sound.ModSoundEvents;
import io.github.noeppi_noeppi.libx.util.NBTX;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class BeeKnight
extends FeyBase
implements IAnimatable {
    public static final EntityDataAccessor<Boolean> AGGRAVATED = SynchedEntityData.m_135353_(BeeKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private BlockPos treasurePos = null;

    public BeeKnight(EntityType<? extends BeeKnight> type, Level level) {
        super(type, Alignment.SUMMER, level);
    }

    public static boolean canSpawn(EntityType<? extends BeeKnight> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        return Tags.Blocks.DIRT.m_8110_((Object)level.m_8055_(pos.m_7495_()).m_60734_()) || Tags.Blocks.SAND.m_8110_((Object)level.m_8055_(pos.m_7495_()).m_60734_());
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return FeyBase.getDefaultAttributes().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22277_, 80.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22280_, 2.25);
    }

    public static void anger(Level level, Player player, BlockPos pos) {
        QuestData quests;
        if (!level.f_46443_ && player instanceof ServerPlayer && ((quests = QuestData.get((ServerPlayer)player)).getAlignment() != Alignment.SUMMER || quests.getReputation() < MobConfig.bee_knight.required_reputation)) {
            AABB aabb = new AABB(pos).m_82400_((double)(2 * MobConfig.bee_knight.aggrevation_range));
            level.m_142425_(ModEntityTypes.beeKnight, aabb, entity -> true).forEach(entity -> {
                if (entity.treasurePos != null && pos.m_123314_((Vec3i)entity.treasurePos, (double)MobConfig.bee_knight.aggrevation_range) && player != entity.getOwner()) {
                    entity.setAggravated(true);
                }
            });
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        this.setTreasurePos(this.m_142538_());
        return super.m_6518_(level, difficulty, reason, data, nbt);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, new FeyAttackableTargetGoal<Player>((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(1, (Goal)new BeeRestrictAttackGoal(this, 1.2f, true));
    }

    @Override
    protected int getMovementRange() {
        return 2 * MobConfig.bee_knight.aggrevation_range;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.f_20916_ > 0 && this.m_142581_() != this.getOwner()) {
            if (this.treasurePos != null && this.treasurePos.m_123314_((Vec3i)this.m_142538_(), (double)(2 * MobConfig.bee_knight.aggrevation_range))) {
                this.m_6710_(this.m_142581_());
                this.setAggravated(true);
            } else {
                this.m_5634_(20.0f);
            }
        }
    }

    @Override
    public SimpleParticleType getParticle() {
        return ParticleTypes.f_123797_;
    }

    @Nonnull
    public InteractionResult m_7111_(@Nonnull Player player, @Nonnull Vec3 hitVec, @Nonnull InteractionHand hand) {
        if (!player.f_19853_.f_46443_ && player instanceof ServerPlayer) {
            QuestData quests = QuestData.get((ServerPlayer)player);
            if (quests.getAlignment() == Alignment.SUMMER && quests.getReputation() >= MobConfig.bee_knight.required_reputation && this.getOwner() == null || player.m_142081_() == this.owner) {
                player.m_6352_((Component)new TranslatableComponent("message.feywild.bee_knight_pass"), player.m_142081_());
            } else {
                player.m_6352_((Component)new TranslatableComponent("message.feywild.bee_knight_fail"), player.m_142081_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag nbt) {
        this.setTreasurePos(NBTX.getPos((CompoundTag)nbt, (String)"TreasurePos", null));
        super.m_7378_(nbt);
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag nbt) {
        if (this.treasurePos != null) {
            NBTX.putPos((CompoundTag)nbt, (String)"TreasurePos", (BlockPos)this.treasurePos);
        }
        super.m_7380_(nbt);
    }

    private <E extends IAnimatable> PlayState flyingPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bee_knight.fly", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController flyingController = new AnimationController((IAnimatable)this, "flyingController", 0.0f, this::flyingPredicate);
        animationData.addAnimationController(flyingController);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGGRAVATED, (Object)false);
    }

    public boolean isAggravated() {
        return (Boolean)this.f_19804_.m_135370_(AGGRAVATED);
    }

    public void setAggravated(boolean aggravated) {
        this.f_19804_.m_135381_(AGGRAVATED, (Object)aggravated);
    }

    @Nullable
    public BlockPos getTreasurePos() {
        return this.treasurePos;
    }

    public void setTreasurePos(@Nullable BlockPos treasurePos) {
        this.treasurePos = treasurePos;
    }

    @Override
    @Nullable
    public Vec3 getCurrentPointOfInterest() {
        if (this.treasurePos == null) {
            return null;
        }
        return new Vec3((double)this.treasurePos.m_123341_(), (double)this.treasurePos.m_123342_(), (double)this.treasurePos.m_123343_());
    }

    public boolean m_7327_(@Nonnull Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            ((LivingEntity)pEntity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 1));
        }
        return super.m_7327_(pEntity);
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource damage) {
        return this.f_19796_.nextBoolean() ? ModSoundEvents.pixieHurt : SoundEvents.f_11741_;
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return this.f_19796_.nextBoolean() ? ModSoundEvents.pixieDeath : SoundEvents.f_11740_;
    }

    @Override
    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11691_;
    }
}

