/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.base;

import com.feywild.feywild.trade.TradeManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;

public abstract class Trader
extends AbstractVillager
implements ReputationEventHandler {
    private int villagerXp;
    private int updateMerchantTimer;
    private boolean increaseProfessionLevelOnUpdate;
    private long lastRestockGameTime;
    private int numberOfRestocksToday;
    private long lastRestockCheckDayTime;
    private VillagerData villagerData = new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35598_, 1);

    public Trader(EntityType<? extends AbstractVillager> entity, Level level) {
        super(entity, level);
    }

    public abstract String getTradeCategory();

    protected void m_8058_(MerchantOffer offer) {
        int i = 3 + this.f_19796_.nextInt(4);
        this.villagerXp += offer.m_45379_();
        if (this.shouldIncreaseLevel()) {
            this.updateMerchantTimer = 40;
            this.increaseProfessionLevelOnUpdate = true;
            i += 5;
        }
        if (offer.m_45383_()) {
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    protected void m_7604_() {
        this.f_35261_ = new MerchantOffers();
        this.villagerData = TradeManager.getTrades(this.m_6095_(), this.getTradeCategory()).initialize((Entity)this, this.villagerData, this.f_35261_, this.f_19796_);
    }

    protected void levelUp() {
        this.villagerData = TradeManager.getTrades(this.m_6095_(), this.getTradeCategory()).levelUp((Entity)this, this.villagerData, this.f_35261_, this.f_19796_);
    }

    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("VillagerLevel", this.villagerData.m_35576_());
        nbt.m_128405_("VillagerXp", this.villagerXp);
        nbt.m_128356_("LastRestock", this.lastRestockGameTime);
        nbt.m_128405_("RestocksToday", this.numberOfRestocksToday);
    }

    public void m_7378_(@Nonnull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.villagerData = new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35598_, nbt.m_128441_("VillagerLevel") ? nbt.m_128451_("VillagerLevel") : 1);
        if (nbt.m_128425_("VillagerXp", 99)) {
            this.villagerXp = nbt.m_128451_("VillagerXp");
        }
        this.lastRestockGameTime = nbt.m_128454_("LastRestock");
        this.numberOfRestocksToday = nbt.m_128451_("RestocksToday");
    }

    private boolean shouldIncreaseLevel() {
        int i = this.getVillagerData().m_35576_();
        return VillagerData.m_35582_((int)i) && this.villagerXp >= VillagerData.m_35577_((int)i);
    }

    protected void m_8024_() {
        if (!this.m_35306_() && this.updateMerchantTimer > 0) {
            --this.updateMerchantTimer;
            if (this.updateMerchantTimer <= 0) {
                if (this.increaseProfessionLevelOnUpdate) {
                    this.levelUp();
                    this.increaseProfessionLevelOnUpdate = false;
                }
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
            }
        }
        super.m_8024_();
    }

    public VillagerData getVillagerData() {
        return this.villagerData;
    }

    public int m_7809_() {
        return this.villagerXp;
    }

    public void m_6814_(@Nonnull ReputationEventType p_213739_1_, @Nonnull Entity p_213739_2_) {
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel level, @Nonnull AgeableMob other) {
        return null;
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_7862_() {
        return true;
    }

    public void restock() {
        this.updateDemand();
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45372_();
        }
        this.lastRestockGameTime = this.f_19853_.m_46467_();
        ++this.numberOfRestocksToday;
    }

    private boolean needsToRestock() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            if (!merchantoffer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    private boolean allowedToRestock() {
        return this.numberOfRestocksToday == 0 || this.numberOfRestocksToday < 2 && this.f_19853_.m_46467_() > this.lastRestockGameTime + 2400L;
    }

    public boolean shouldRestock() {
        boolean timeForRestock;
        boolean bl = timeForRestock = this.f_19853_.m_46467_() > this.lastRestockGameTime + 12000L;
        if (this.lastRestockCheckDayTime > 0L && !timeForRestock) {
            long lastRestockDay = this.lastRestockCheckDayTime / 24000L;
            long currentRestockDay = this.f_19853_.m_46468_() / 24000L;
            if (currentRestockDay > lastRestockDay) {
                timeForRestock = true;
            }
        }
        this.lastRestockCheckDayTime = this.f_19853_.m_46468_();
        if (timeForRestock) {
            this.lastRestockGameTime = this.f_19853_.m_46467_();
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    private void catchUpDemand() {
        int restocksLeft = 2 - this.numberOfRestocksToday;
        if (restocksLeft > 0) {
            for (MerchantOffer merchantoffer : this.m_6616_()) {
                merchantoffer.m_45372_();
            }
        }
        for (int j = 0; j < restocksLeft; ++j) {
            this.updateDemand();
        }
    }

    private void updateDemand() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45369_();
        }
    }

    private void resetNumberOfRestocks() {
        this.catchUpDemand();
        this.numberOfRestocksToday = 0;
    }
}

