/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.block.entity.DwarvenAnvil;
import com.feywild.feywild.entity.DwarfBlacksmith;
import com.feywild.feywild.entity.goals.MovementRestrictionGoal;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class GoToAnvilPositionGoal
extends MovementRestrictionGoal {
    private final DwarfBlacksmith entity;
    private DwarvenAnvil tile;
    private int ticksLeft = 0;

    public GoToAnvilPositionGoal(DwarfBlacksmith entity, Supplier<BlockPos> pos, int maxMovementRange) {
        super(GoToAnvilPositionGoal.asVector(pos), maxMovementRange);
        this.entity = entity;
    }

    public void m_8037_() {
        this.init();
        if (!this.entity.isTamed()) {
            this.reset();
        } else if (this.tile != null && this.ticksLeft > 0) {
            if (!this.tile.canCraft()) {
                this.reset();
                return;
            }
            --this.ticksLeft;
            if (this.ticksLeft == 0) {
                this.tile.craft();
                this.reset();
            } else {
                Vec3 target = (Vec3)this.targetPosition.get();
                if (target != null && this.tile.canCraft()) {
                    if (this.ticksLeft == 20) {
                        this.entity.m_5496_(SoundEvents.f_11671_, 1.0f, 1.0f);
                    } else if (this.ticksLeft == 50) {
                        this.entity.setState(DwarfBlacksmith.State.WORKING);
                    } else if (this.ticksLeft <= 110) {
                        this.entity.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, 0.5);
                        this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, target);
                    }
                } else {
                    this.reset();
                }
            }
        }
    }

    public void m_8056_() {
        this.ticksLeft = 120;
    }

    protected void reset() {
        this.entity.setState(DwarfBlacksmith.State.IDLE);
        this.ticksLeft = -1;
    }

    public boolean m_8045_() {
        this.init();
        return this.ticksLeft > 0 && this.entity.isTamed() && this.tile != null && this.targetPosition.get() != null;
    }

    @Override
    public boolean m_8036_() {
        this.init();
        return this.tile != null && this.targetPosition.get() != null && this.tile.canCraft();
    }

    private void init() {
        if (this.tile == null && this.entity.getSummonPos() != null) {
            BlockEntity tile = this.entity.f_19853_.m_7702_(this.entity.getSummonPos());
            this.tile = tile instanceof DwarvenAnvil ? (DwarvenAnvil)tile : null;
        }
    }
}

