/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.entity.base.Fey;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.sound.ModSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;

public class TargetBreedGoal
extends Goal {
    private static final TargetingConditions TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private final Fey entity;
    private Animal targetAnimal;
    private Animal partner;
    private int ticksLeft = 0;

    public TargetBreedGoal(Fey entity) {
        this.entity = entity;
    }

    public void m_8037_() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.targetAnimal == null || this.partner == null || !this.targetAnimal.m_6084_() || !this.partner.m_6084_()) {
                this.targetAnimal = this.findTarget();
                this.partner = this.findPartner();
                if (this.targetAnimal == null || this.partner == null || !this.targetAnimal.m_6084_() || !this.partner.m_6084_()) {
                    this.reset();
                    return;
                }
            }
            if (!this.targetAnimal.m_6084_() || !this.partner.m_6084_() || this.targetAnimal.m_146764_() != 0 || this.partner.m_146764_() != 0) {
                this.reset();
                return;
            }
            if (this.ticksLeft <= 0) {
                if (this.entity.f_19853_ instanceof ServerLevel) {
                    this.targetAnimal.m_27563_((ServerLevel)this.entity.f_19853_, this.partner);
                    FeywildMod.getNetwork().sendParticles(this.entity.f_19853_, ParticleSerializer.Type.ANIMAL_BREED, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), this.targetAnimal.m_20185_(), this.targetAnimal.m_20186_(), this.targetAnimal.m_20189_());
                }
                this.reset();
            } else if (this.ticksLeft == 110) {
                this.spellCasting();
            } else if (this.ticksLeft <= 100) {
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetAnimal.m_20182_());
                this.entity.m_21573_().m_5624_((Entity)this.targetAnimal, 0.5);
            }
        }
    }

    public void m_8056_() {
        this.ticksLeft = 120;
        this.targetAnimal = null;
        this.partner = null;
    }

    private void spellCasting() {
        this.entity.setCasting(true);
        this.entity.m_5496_(ModSoundEvents.pixieSpellcasting, 1.0f, 1.0f);
    }

    protected void reset() {
        this.entity.setCasting(false);
        this.targetAnimal = null;
        this.partner = null;
        this.ticksLeft = -1;
    }

    public boolean m_8045_() {
        return this.ticksLeft > 0;
    }

    public boolean m_8036_() {
        return this.entity.isTamed() && this.entity.f_19853_.f_46441_.nextFloat() < 0.01f;
    }

    @Nullable
    private Animal findTarget() {
        double distance = Double.MAX_VALUE;
        Animal current = null;
        for (Animal animal : this.entity.f_19853_.m_45971_(Animal.class, TARGETING, (LivingEntity)this.entity, this.entity.m_142469_().m_82400_(8.0))) {
            if (animal.m_146764_() != 0 || !(this.entity.m_20280_((Entity)animal) < distance)) continue;
            current = animal;
            distance = this.entity.m_20280_((Entity)animal);
        }
        return current;
    }

    @Nullable
    private Animal findPartner() {
        if (this.targetAnimal != null) {
            double distance = Double.MAX_VALUE;
            Animal current = null;
            for (Animal animal : this.targetAnimal.f_19853_.m_45971_(Animal.class, TARGETING, (LivingEntity)this.targetAnimal, this.targetAnimal.m_142469_().m_82400_(8.0))) {
                if (animal.m_146764_() != 0) continue;
                int oldInLove1 = this.targetAnimal.m_27591_();
                int oldInLove2 = animal.m_27591_();
                this.targetAnimal.m_27601_(1);
                animal.m_27601_(1);
                if (this.targetAnimal.m_7848_(animal) && this.targetAnimal.m_20280_((Entity)animal) < distance) {
                    current = animal;
                    distance = this.targetAnimal.m_20280_((Entity)animal);
                }
                this.targetAnimal.m_27601_(oldInLove1);
                animal.m_27601_(oldInLove2);
            }
            return current;
        }
        return null;
    }
}

