/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.jei;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.block.ModBlocks;
import com.feywild.feywild.recipes.DwarvenAnvilRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DwarvenAnvilRecipeCategory
implements IRecipeCategory<DwarvenAnvilRecipe> {
    public static final ResourceLocation UID = new ResourceLocation(FeywildMod.getInstance().modid, "dwarven_anvil");
    public static final ResourceLocation TEXTURE = new ResourceLocation(FeywildMod.getInstance().modid, "textures/gui/dwarven_anvil_jei.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic manaOverlay;

    public DwarvenAnvilRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 156, 69);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.dwarvenAnvil));
        this.manaOverlay = helper.createDrawable(TEXTURE, 156, 0, 13, 66);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends DwarvenAnvilRecipe> getRecipeClass() {
        return DwarvenAnvilRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return ModBlocks.dwarvenAnvil.m_49954_();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(DwarvenAnvilRecipe recipe, IIngredients ii) {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        inputs.add(recipe.getSchematics());
        inputs.addAll(recipe.getInputs());
        ii.setInputIngredients(inputs);
        ii.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull DwarvenAnvilRecipe recipe, IIngredients ii) {
        layout.getItemStacks().init(0, true, 18, 1);
        if (ii.getInputs(VanillaTypes.ITEM).size() >= 2) {
            layout.getItemStacks().init(1, true, 70, 8);
        }
        if (ii.getInputs(VanillaTypes.ITEM).size() >= 3) {
            layout.getItemStacks().init(2, true, 100, 22);
        }
        if (ii.getInputs(VanillaTypes.ITEM).size() >= 4) {
            layout.getItemStacks().init(3, true, 84, 43);
        }
        if (ii.getInputs(VanillaTypes.ITEM).size() >= 5) {
            layout.getItemStacks().init(4, true, 58, 43);
        }
        if (ii.getInputs(VanillaTypes.ITEM).size() >= 6) {
            layout.getItemStacks().init(5, true, 43, 22);
        }
        layout.getItemStacks().init(ii.getInputs(VanillaTypes.ITEM).size(), false, 137, 49);
        layout.getItemStacks().set(ii);
    }

    public void draw(@Nonnull DwarvenAnvilRecipe recipe, @Nonnull PoseStack poseStack, double mouseX, double mouseY) {
        int maskBottom = (int)Math.round((double)Mth.m_14045_((int)recipe.getMana(), (int)0, (int)1000) / 1000.0 * (double)this.manaOverlay.getHeight());
        this.manaOverlay.draw(poseStack, 1, 2, 0, maskBottom, 0, 0);
        Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)new TranslatableComponent("screen.feywild.mana_amount", new Object[]{recipe.getMana()}), 100.0f, 0.0f, 0xFFFFFF);
    }
}

