/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class QuestDisplay {
    public final Component title;
    public final Component description;
    @Nullable
    public final SoundEvent sound;

    public QuestDisplay(Component title, Component description, @Nullable SoundEvent sound) {
        this.title = title;
        this.description = description;
        this.sound = sound;
    }

    public static QuestDisplay fromJson(JsonObject json) {
        MutableComponent title = Component.Serializer.m_130691_((JsonElement)json.get("title"));
        MutableComponent description = Component.Serializer.m_130691_((JsonElement)json.get("description"));
        SoundEvent sound = json.has("sound") ? (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(json.get("sound").getAsString())) : null;
        return new QuestDisplay((Component)title, (Component)description, sound);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("title", Component.Serializer.m_130716_((Component)this.title));
        json.add("description", Component.Serializer.m_130716_((Component)this.description));
        if (this.sound != null && this.sound.getRegistryName() != null) {
            json.addProperty("sound", this.sound.getRegistryName().toString());
        }
        return json;
    }

    public static QuestDisplay fromNetwork(FriendlyByteBuf buffer) {
        Component title = buffer.m_130238_();
        Component description = buffer.m_130238_();
        SoundEvent sound = buffer.readBoolean() ? (SoundEvent)buffer.readRegistryId() : null;
        return new QuestDisplay(title, description, sound);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130083_(this.title);
        buffer.m_130083_(this.description);
        buffer.writeBoolean(this.sound != null);
        if (this.sound != null) {
            buffer.writeRegistryId((IForgeRegistryEntry)this.sound);
        }
    }
}

