/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest.player;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.quest.player.QuestData;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class CapabilityQuests {
    public static final ResourceLocation KEY = new ResourceLocation(FeywildMod.getInstance().modid, "player_quests");
    public static final Capability<QuestData> QUESTS = CapabilityManager.get((CapabilityToken)new CapabilityToken<QuestData>(){});

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(QuestData.class);
    }

    public static void attachPlayerCaps(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)object;
            event.addCapability(KEY, (ICapabilityProvider)new Provider(QUESTS, (LazyValue<QuestData>)new LazyValue(() -> {
                QuestData data = new QuestData();
                data.attach(player);
                return data;
            })));
        }
    }

    public static void playerCopy(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(QUESTS).ifPresent(oldData -> event.getPlayer().getCapability(QUESTS).ifPresent(newData -> newData.read(oldData.write())));
        }
    }

    private static class Provider
    implements ICapabilityProvider,
    INBTSerializable<Tag> {
        public final Capability<QuestData> capability;
        public final LazyValue<QuestData> value;

        public Provider(Capability<QuestData> capability, LazyValue<QuestData> value) {
            this.capability = capability;
            this.value = value;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == this.capability ? LazyOptional.of(() -> this.value.get()).cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return ((QuestData)this.value.get()).write();
        }

        public void deserializeNBT(Tag nbt) {
            Tag tag = nbt;
            if (tag instanceof CompoundTag) {
                CompoundTag tag2 = (CompoundTag)tag;
                ((QuestData)this.value.get()).read(tag2);
            }
        }
    }
}

