/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.structure.load;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.block.ModBlocks;
import com.feywild.feywild.config.CompatConfig;
import com.feywild.feywild.entity.DwarfBlacksmith;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.entity.base.Trader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.structures.SinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElementType;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class FeywildStructurePiece
extends SinglePoolElement {
    public static final ResourceLocation ID = new ResourceLocation(FeywildMod.getInstance().modid, "structure_piece");
    public static final Codec<FeywildStructurePiece> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)FeywildStructurePiece.m_69149_(), (App)FeywildStructurePiece.m_69146_(), (App)FeywildStructurePiece.m_69229_()).apply((Applicative)builder, FeywildStructurePiece::new));
    public static final StructurePoolElementType<FeywildStructurePiece> TYPE = () -> CODEC;

    protected FeywildStructurePiece(Either<ResourceLocation, StructureTemplate> template, Supplier<StructureProcessorList> processors, StructureTemplatePool.Projection projection) {
        super(template, processors, projection);
    }

    public boolean m_6791_(@Nonnull StructureManager templates, @Nonnull WorldGenLevel level, @Nonnull StructureFeatureManager structures2, @Nonnull ChunkGenerator generator, @Nonnull BlockPos fromPos, @Nonnull BlockPos toPos, @Nonnull Rotation rot, @Nonnull BoundingBox box, @Nonnull Random random, boolean jigsaw) {
        StructurePlaceSettings settings;
        StructureTemplate template = (StructureTemplate)this.f_69098_.map(arg_0 -> ((StructureManager)templates).m_74341_(arg_0), Function.identity());
        if (!template.m_74536_((ServerLevelAccessor)level, fromPos, toPos, settings = this.m_8122_(rot, box, jigsaw), random, 18)) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo info : StructureTemplate.processBlockInfos((LevelAccessor)level, (BlockPos)fromPos, (BlockPos)toPos, (StructurePlaceSettings)settings, (List)this.m_69141_(templates, fromPos, rot, false), (StructureTemplate)template)) {
            this.handleCustomDataMarker(templates, structures2, level, info, info.f_74675_, rot, random, box);
        }
        return true;
    }

    @Nonnull
    protected StructurePlaceSettings m_8122_(@Nonnull Rotation rot, @Nonnull BoundingBox box, boolean jigsaw) {
        StructurePlaceSettings settings = super.m_8122_(rot, box, jigsaw);
        settings.m_74397_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        return settings;
    }

    public void handleCustomDataMarker(StructureManager templates, StructureFeatureManager structures2, WorldGenLevel level, StructureTemplate.StructureBlockInfo block, BlockPos pos, Rotation rot, Random random, BoundingBox box) {
        String data = block.f_74677_ == null ? "" : block.f_74677_.m_128461_("metadata");
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
        if (data.equals("Waystone") && CompatConfig.waystones) {
            this.placePiece(templates, level, "waystone", pos, random);
        } else if (data.equals("Dwarf")) {
            this.placeDwarf(level, pos);
        }
        super.m_69157_((LevelAccessor)level, block, pos, rot, random, box);
    }

    @Nonnull
    public StructurePoolElementType<?> m_6379_() {
        return TYPE;
    }

    private void placePiece(StructureManager templates, WorldGenLevel level, String name, BlockPos pos, Random random) {
        StructureTemplate template = templates.m_74341_(new ResourceLocation(FeywildMod.getInstance().modid, "parts/" + name));
        template.m_74536_((ServerLevelAccessor)level, pos, pos, new StructurePlaceSettings(), random, 4);
    }

    private void placeDwarf(WorldGenLevel level, BlockPos pos) {
        if (CompatConfig.mythic_alfheim.locked) {
            level.m_7731_(pos, ModBlocks.ancientRunestone.m_49966_(), 2);
        } else {
            DwarfBlacksmith entity = new DwarfBlacksmith((EntityType<? extends Trader>)ModEntityTypes.dwarfBlacksmith, (Level)level.m_6018_());
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            entity.setTamed(false);
            entity.m_21530_();
            this.addEntity(level, (Entity)entity);
        }
    }

    private void addEntity(WorldGenLevel level, Entity entity) {
        if (level instanceof WorldGenRegion) {
            int x = (int)Math.floor(entity.m_20185_()) >> 4;
            int z = (int)Math.floor(entity.m_20189_()) >> 4;
            if (((WorldGenRegion)level).m_143488_().f_45578_ == x && ((WorldGenRegion)level).m_143488_().f_45579_ == z) {
                level.m_7967_(entity);
            }
        } else {
            level.m_7967_(entity);
        }
    }
}

