/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild;

import com.feywild.feywild.FeyPlayerData;
import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.config.ClientConfig;
import com.feywild.feywild.config.MiscConfig;
import com.feywild.feywild.config.data.ScrollSelectType;
import com.feywild.feywild.entity.BeeKnight;
import com.feywild.feywild.item.ModItems;
import com.feywild.feywild.network.OpenLibraryScreenSerializer;
import com.feywild.feywild.network.OpeningScreenSerializer;
import com.feywild.feywild.network.TradesSerializer;
import com.feywild.feywild.quest.player.CompletableTaskInfo;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.quest.task.BiomeTask;
import com.feywild.feywild.quest.task.CraftTask;
import com.feywild.feywild.quest.task.ItemTask;
import com.feywild.feywild.quest.task.KillTask;
import com.feywild.feywild.quest.task.StructureTask;
import com.feywild.feywild.trade.TradeManager;
import com.feywild.feywild.util.FeywildTitleScreen;
import com.feywild.feywild.util.LibraryBooks;
import com.feywild.feywild.world.dimension.market.MarketHandler;
import io.github.noeppi_noeppi.libx.event.ConfigLoadedEvent;
import io.github.noeppi_noeppi.libx.event.DataPacksReloadedEvent;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class EventListener {
    @SubscribeEvent
    public void craftItem(PlayerEvent.ItemCraftedEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            QuestData.get((ServerPlayer)event.getPlayer()).checkComplete(CraftTask.INSTANCE, event.getCrafting());
        }
    }

    @SubscribeEvent
    public void playerKill(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            QuestData quests = QuestData.get(player);
            quests.checkComplete(KillTask.INSTANCE, event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.player.f_19797_ % 20 == 0 && !event.player.f_19853_.f_46443_ && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            QuestData quests = QuestData.get(player2);
            player2.m_150109_().f_35974_.forEach(stack -> quests.checkComplete(ItemTask.INSTANCE, stack));
            player2.m_9236_().m_45837_(player2.m_142538_()).ifPresent(biome -> quests.checkComplete(BiomeTask.INSTANCE, biome.m_135782_()));
            for (CompletableTaskInfo completableTaskInfo : quests.getAllCurrentTasks(StructureTask.INSTANCE)) {
                if (!player2.m_9236_().m_8595_().m_47285_(player2.m_142538_(), true, (StructureFeature)completableTaskInfo.getValue()).m_73603_()) continue;
                completableTaskInfo.checkComplete((StructureFeature)completableTaskInfo.getValue());
            }
        }
    }

    @SubscribeEvent
    public void entityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!event.getWorld().f_46443_ && event.getPlayer() instanceof ServerPlayer && event.getTarget() instanceof Villager && event.getTarget().m_19880_().contains("feywild_librarian")) {
            event.getPlayer().m_6352_((Component)new TranslatableComponent("librarian.feywild.initial"), event.getPlayer().m_142081_());
            FeywildMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new OpenLibraryScreenSerializer.Message(event.getTarget().m_5446_(), LibraryBooks.getLibraryBooks()));
            event.getPlayer().m_21011_(event.getHand(), true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().f_19853_.f_46443_) {
            if (event.getPlayer() instanceof ServerPlayer) {
                FeywildMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new TradesSerializer.Message(TradeManager.buildRecipes()));
            }
            if (!FeyPlayerData.get(event.getPlayer()).m_128471_("feywild_got_lexicon") && MiscConfig.initial_lexicon) {
                event.getPlayer().m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.feywildLexicon));
                FeyPlayerData.get(event.getPlayer()).m_128379_("feywild_got_lexicon", true);
            }
            if (!FeyPlayerData.get(event.getPlayer()).m_128471_("feywild_got_scroll") && MiscConfig.initial_scroll == ScrollSelectType.LOGIN) {
                FeywildMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new OpeningScreenSerializer.Message());
            }
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        FeyPlayerData.copy(event.getOriginal(), event.getPlayer());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void openGui(GuiOpenEvent event) {
        if (ClientConfig.replace_menu && event.getGui() instanceof TitleScreen && !(event.getGui() instanceof FeywildTitleScreen)) {
            event.setGui((Screen)new FeywildTitleScreen());
        }
    }

    @SubscribeEvent
    public void loadConfig(ConfigLoadedEvent event) {
        if (event.getConfigClass() == MiscConfig.class) {
            ModItems.feyDust.updateFood();
        }
    }

    @SubscribeEvent
    public void blockInteract(PlayerInteractEvent.RightClickBlock event) {
        BeeKnight.anger(event.getWorld(), event.getPlayer(), event.getPos());
    }

    @SubscribeEvent
    public void blockInteract(PlayerInteractEvent.LeftClickBlock event) {
        BeeKnight.anger(event.getWorld(), event.getPlayer(), event.getPos());
    }

    @SubscribeEvent
    public void tickWorld(TickEvent.WorldTickEvent event) {
        if (event.world instanceof ServerLevel && event.world.m_46472_() == Level.f_46428_) {
            MarketHandler.update(((ServerLevel)event.world).m_142572_());
        }
    }

    @SubscribeEvent
    public void afterReload(DataPacksReloadedEvent event) {
        FeywildMod.getNetwork().channel.send(PacketDistributor.ALL.noArg(), (Object)new TradesSerializer.Message(TradeManager.buildRecipes()));
    }

    @SubscribeEvent
    public void lootTableLoad(LootTableLoadEvent event) {
        LootPool pool;
        if (event.getName().equals((Object)BuiltInLootTables.f_78759_) && (pool = event.getTable().getPool("main")) != null) {
            this.addEntry(pool, LootItem.m_79579_((ItemLike)ModItems.schematicsGemTransmutation).m_79707_(8).m_7512_());
            this.addEntry(pool, LootItem.m_79579_((ItemLike)ModItems.inactiveMarketRuneStone).m_79707_(MiscConfig.rune_stone_weight).m_7512_());
            this.addEntry(pool, LootItem.m_79579_((ItemLike)ModItems.lesserFeyGem).m_79707_(30).m_7512_());
            this.addEntry(pool, LootItem.m_79579_((ItemLike)ModItems.greaterFeyGem).m_79707_(15).m_7512_());
            this.addEntry(pool, LootItem.m_79579_((ItemLike)ModItems.shinyFeyGem).m_79707_(8).m_7512_());
            this.addEntry(pool, LootItem.m_79579_((ItemLike)ModItems.brilliantFeyGem).m_79707_(4).m_7512_());
            this.addEntry(pool, LootItem.m_79579_((ItemLike)ModItems.feywildMusicDisc).m_79707_(2).m_7512_());
        }
    }

    private void addEntry(LootPool pool, LootPoolEntryContainer entry) {
        try {
            List lootEntries = (List)ObfuscationReflectionHelper.findField(LootPool.class, (String)"f_79023_").get(pool);
            if (lootEntries.stream().noneMatch(e -> e == entry)) {
                lootEntries.add(entry);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

