/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild;

import com.feywild.feywild.EventListener;
import com.feywild.feywild.FeywildTab;
import com.feywild.feywild.MarketProtectEvents;
import com.feywild.feywild.block.entity.mana.CapabilityMana;
import com.feywild.feywild.compat.MineMentionCompat;
import com.feywild.feywild.config.ClientConfig;
import com.feywild.feywild.config.CompatConfig;
import com.feywild.feywild.config.MiscConfig;
import com.feywild.feywild.config.MobConfig;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.config.mapper.BiomeTypeMapper;
import com.feywild.feywild.config.validator.StructureDataValidator;
import com.feywild.feywild.entity.BeeKnight;
import com.feywild.feywild.entity.DwarfBlacksmith;
import com.feywild.feywild.entity.MarketDwarf;
import com.feywild.feywild.entity.ModEntityTypes;
import com.feywild.feywild.entity.base.Fey;
import com.feywild.feywild.entity.base.Mandragora;
import com.feywild.feywild.entity.model.AutumnPixieModel;
import com.feywild.feywild.entity.model.BeeKnightModel;
import com.feywild.feywild.entity.model.MandragoraModel;
import com.feywild.feywild.entity.model.SpringPixieModel;
import com.feywild.feywild.entity.model.SummerPixieModel;
import com.feywild.feywild.entity.model.WinterPixieModel;
import com.feywild.feywild.entity.render.BasePixieRenderer;
import com.feywild.feywild.entity.render.DwarfBlacksmithRenderer;
import com.feywild.feywild.entity.render.MandragoraRenderer;
import com.feywild.feywild.entity.render.MarketDwarfRenderer;
import com.feywild.feywild.network.FeywildNetwork;
import com.feywild.feywild.particles.ModParticleFactories;
import com.feywild.feywild.quest.QuestManager;
import com.feywild.feywild.quest.player.CapabilityQuests;
import com.feywild.feywild.quest.reward.ItemReward;
import com.feywild.feywild.quest.reward.RewardTypes;
import com.feywild.feywild.quest.task.BiomeTask;
import com.feywild.feywild.quest.task.CraftTask;
import com.feywild.feywild.quest.task.FeyGiftTask;
import com.feywild.feywild.quest.task.ItemTask;
import com.feywild.feywild.quest.task.KillTask;
import com.feywild.feywild.quest.task.SpecialTask;
import com.feywild.feywild.quest.task.StructureTask;
import com.feywild.feywild.quest.task.TaskTypes;
import com.feywild.feywild.sound.FeywildMenuMusic;
import com.feywild.feywild.trade.TradeManager;
import com.feywild.feywild.util.LibraryBooks;
import com.feywild.feywild.world.BiomeLoader;
import com.feywild.feywild.world.StructureLoader;
import com.feywild.feywild.world.biome.ModBiomeGeneration;
import com.feywild.feywild.world.dimension.market.MarketGenerator;
import com.feywild.feywild.world.gen.OreType;
import com.feywild.feywild.world.structure.ModStructures;
import com.feywild.feywild.world.structure.load.FeywildStructurePiece;
import io.github.noeppi_noeppi.libx.config.ConfigManager;
import io.github.noeppi_noeppi.libx.config.ConfigValidator;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.ModXRegistration;
import io.github.noeppi_noeppi.libx.mod.registration.RegistrationBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="feywild")
public final class FeywildMod
extends ModXRegistration {
    private static FeywildMod instance;
    private static FeywildNetwork network;

    public FeywildMod() {
        super((CreativeModeTab)new FeywildTab("feywild"));
        instance = this;
        network = new FeywildNetwork((ModX)this);
        ConfigManager.registerValueMapper((String)this.modid, (ValueMapper)new BiomeTypeMapper());
        ConfigManager.registerConfigValidator((String)this.modid, (ConfigValidator)new StructureDataValidator());
        ConfigManager.registerConfig((ResourceLocation)new ResourceLocation(this.modid, "misc"), MiscConfig.class, (boolean)false);
        ConfigManager.registerConfig((ResourceLocation)new ResourceLocation(this.modid, "world_gen"), WorldGenConfig.class, (boolean)false);
        ConfigManager.registerConfig((ResourceLocation)new ResourceLocation(this.modid, "mob_spawns"), MobConfig.class, (boolean)false);
        ConfigManager.registerConfig((ResourceLocation)new ResourceLocation(this.modid, "compat"), CompatConfig.class, (boolean)false);
        ConfigManager.registerConfig((ResourceLocation)new ResourceLocation(this.modid, "client"), ClientConfig.class, (boolean)true);
        GeckoLib.initialize();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CapabilityMana::register);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CapabilityQuests::register);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::entityAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOW, ModParticleFactories::registerParticles);
        MinecraftForge.EVENT_BUS.addListener(this::reloadData);
        MinecraftForge.EVENT_BUS.addListener(BiomeLoader::loadBiome);
        MinecraftForge.EVENT_BUS.addListener(StructureLoader::addStructureSettings);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityQuests::attachPlayerCaps);
        MinecraftForge.EVENT_BUS.addListener(CapabilityQuests::playerCopy);
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
        MinecraftForge.EVENT_BUS.register((Object)new MarketProtectEvents());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(FeywildMenuMusic::playSound));
        TaskTypes.register(new ResourceLocation(this.modid, "craft"), CraftTask.INSTANCE);
        TaskTypes.register(new ResourceLocation(this.modid, "fey_gift"), FeyGiftTask.INSTANCE);
        TaskTypes.register(new ResourceLocation(this.modid, "item"), ItemTask.INSTANCE);
        TaskTypes.register(new ResourceLocation(this.modid, "kill"), KillTask.INSTANCE);
        TaskTypes.register(new ResourceLocation(this.modid, "special"), SpecialTask.INSTANCE);
        TaskTypes.register(new ResourceLocation(this.modid, "biome"), BiomeTask.INSTANCE);
        TaskTypes.register(new ResourceLocation(this.modid, "structure"), StructureTask.INSTANCE);
        RewardTypes.register(new ResourceLocation(this.modid, "item"), ItemReward.INSTANCE);
    }

    @Nonnull
    public static FeywildMod getInstance() {
        return instance;
    }

    @Nonnull
    public static FeywildNetwork getNetwork() {
        return network;
    }

    protected void initRegistration(RegistrationBuilder builder) {
        builder.setVersion(1);
    }

    protected void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Registry.m_122965_((Registry)Registry.f_122892_, (ResourceLocation)FeywildStructurePiece.ID, FeywildStructurePiece.TYPE);
            ModBiomeGeneration.setupBiomes();
            OreType.setupOres();
            ModStructures.setupStructures();
            SpawnPlacements.m_21754_(ModEntityTypes.springPixie, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Fey::canSpawn);
            SpawnPlacements.m_21754_(ModEntityTypes.autumnPixie, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Fey::canSpawn);
            SpawnPlacements.m_21754_(ModEntityTypes.summerPixie, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Fey::canSpawn);
            SpawnPlacements.m_21754_(ModEntityTypes.winterPixie, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Fey::canSpawn);
            SpawnPlacements.m_21754_(ModEntityTypes.dwarfBlacksmith, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DwarfBlacksmith::canSpawn);
            SpawnPlacements.m_21754_(ModEntityTypes.beeKnight, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BeeKnight::canSpawn);
            MarketGenerator.registerMarketDwarf(new ResourceLocation(this.modid, "miner"), ModEntityTypes.dwarfMiner, new BlockPos(11, 64, 20));
            MarketGenerator.registerMarketDwarf(new ResourceLocation(this.modid, "baker"), ModEntityTypes.dwarfBaker, new BlockPos(-3, 64, 10));
            MarketGenerator.registerMarketDwarf(new ResourceLocation(this.modid, "shepherd"), ModEntityTypes.dwarfShepherd, new BlockPos(0, 63, -3));
            MarketGenerator.registerMarketDwarf(new ResourceLocation(this.modid, "artificer"), ModEntityTypes.dwarfArtificer, new BlockPos(7, 63, -2));
            MarketGenerator.registerMarketDwarf(new ResourceLocation(this.modid, "dragon_hunter"), ModEntityTypes.dwarfDragonHunter, new BlockPos(21, 63, 20));
            MarketGenerator.registerMarketDwarf(new ResourceLocation(this.modid, "tool_smith"), ModEntityTypes.dwarfToolsmith, new BlockPos(21, 63, 11));
            if (ModList.get().isLoaded("minemention")) {
                MineMentionCompat.setup();
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_(ModEntityTypes.beeKnight, BasePixieRenderer.create(BeeKnightModel::new));
        EntityRenderers.m_174036_(ModEntityTypes.dwarfToolsmith, MarketDwarfRenderer::new);
        EntityRenderers.m_174036_(ModEntityTypes.dwarfArtificer, MarketDwarfRenderer::new);
        EntityRenderers.m_174036_(ModEntityTypes.dwarfDragonHunter, MarketDwarfRenderer::new);
        EntityRenderers.m_174036_(ModEntityTypes.dwarfBaker, MarketDwarfRenderer::new);
        EntityRenderers.m_174036_(ModEntityTypes.dwarfMiner, MarketDwarfRenderer::new);
        EntityRenderers.m_174036_(ModEntityTypes.dwarfBlacksmith, DwarfBlacksmithRenderer::new);
        EntityRenderers.m_174036_(ModEntityTypes.dwarfShepherd, MarketDwarfRenderer::new);
        EntityRenderers.m_174036_(ModEntityTypes.springPixie, BasePixieRenderer.create(SpringPixieModel::new));
        EntityRenderers.m_174036_(ModEntityTypes.summerPixie, BasePixieRenderer.create(SummerPixieModel::new));
        EntityRenderers.m_174036_(ModEntityTypes.autumnPixie, BasePixieRenderer.create(AutumnPixieModel::new));
        EntityRenderers.m_174036_(ModEntityTypes.winterPixie, BasePixieRenderer.create(WinterPixieModel::new));
        EntityRenderers.m_174036_(ModEntityTypes.melonMandragora, MandragoraRenderer.create(MandragoraModel::new));
        EntityRenderers.m_174036_(ModEntityTypes.onionMandragora, MandragoraRenderer.create(MandragoraModel::new));
        EntityRenderers.m_174036_(ModEntityTypes.potatoMandragora, MandragoraRenderer.create(MandragoraModel::new));
        EntityRenderers.m_174036_(ModEntityTypes.pumpkinMandragora, MandragoraRenderer.create(MandragoraModel::new));
        EntityRenderers.m_174036_(ModEntityTypes.tomatoMandragora, MandragoraRenderer.create(MandragoraModel::new));
    }

    private void entityAttributes(EntityAttributeCreationEvent event) {
        event.put(ModEntityTypes.springPixie, Fey.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.winterPixie, Fey.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.summerPixie, Fey.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.autumnPixie, Fey.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.dwarfBlacksmith, DwarfBlacksmith.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.dwarfArtificer, MarketDwarf.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.dwarfBaker, MarketDwarf.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.dwarfMiner, MarketDwarf.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.dwarfDragonHunter, MarketDwarf.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.dwarfShepherd, MarketDwarf.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.dwarfToolsmith, MarketDwarf.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.melonMandragora, Mandragora.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.onionMandragora, Mandragora.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.potatoMandragora, Mandragora.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.pumpkinMandragora, Mandragora.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.tomatoMandragora, Mandragora.getDefaultAttributes().m_22265_());
        event.put(ModEntityTypes.beeKnight, BeeKnight.getDefaultAttributes().m_22265_());
    }

    @SubscribeEvent
    public void reloadData(AddReloadListenerEvent event) {
        event.addListener(LibraryBooks.createReloadListener());
        event.addListener(TradeManager.createReloadListener());
        event.addListener(QuestManager.createReloadListener());
    }
}

