/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block;

import com.feywild.feywild.block.entity.LibraryBell;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.quest.task.SpecialTask;
import com.feywild.feywild.quest.util.SpecialTaskAction;
import io.github.noeppi_noeppi.libx.base.tile.BlockBE;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LibraryBellBlock
extends BlockBE<LibraryBell> {
    public static final VoxelShape SHAPE = LibraryBellBlock.m_49796_((double)5.1875, (double)0.0, (double)5.26563, (double)10.8125, (double)3.23438, (double)10.70313);

    public LibraryBellBlock(ModX mod) {
        super(mod, LibraryBell.class, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(-1.0f, 3600000.0f).m_60993_().m_60955_().m_60977_().m_60910_().m_60918_(SoundType.f_56742_));
    }

    public void m_6810_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean moving) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            Entity security;
            LibraryBell tile = (LibraryBell)this.getBlockEntity(level, pos);
            if (tile.getLibrarian() != null) {
                Entity librarian = ((ServerLevel)level).m_8791_(tile.getLibrarian());
                if (librarian instanceof Villager) {
                    ((Villager)librarian).m_35524_();
                }
                if (librarian != null) {
                    librarian.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            if (tile.getSecurity() != null && (security = ((ServerLevel)level).m_8791_(tile.getSecurity())) != null) {
                security.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter levelIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult trace) {
        if (level.f_46443_) {
            level.m_5594_(player, pos, SoundEvents.f_12210_, SoundSource.BLOCKS, 1.0f, 1.2f);
        } else {
            LibraryBell blockEntity = (LibraryBell)this.getBlockEntity(level, pos);
            if (player.m_36316_().getId().equals(blockEntity.getPlayer())) {
                blockEntity.setAnnoyance(blockEntity.getAnnoyance() + 1);
            } else {
                blockEntity.setPlayer(player.m_36316_().getId());
                blockEntity.setAnnoyance(0);
            }
            if (level instanceof ServerLevel) {
                Entity security;
                Entity librarian = blockEntity.getLibrarian() != null ? ((ServerLevel)level).m_8791_(blockEntity.getLibrarian()) : null;
                Entity entity = security = blockEntity.getSecurity() != null ? ((ServerLevel)level).m_8791_(blockEntity.getSecurity()) : null;
                if (blockEntity.getAnnoyance() >= 10 && librarian != null && librarian.m_6084_()) {
                    blockEntity.setAnnoyance(0);
                    if (security == null) {
                        IronGolem golem = new IronGolem(EntityType.f_20460_, level);
                        golem.m_28887_(false);
                        golem.m_6710_((LivingEntity)player);
                        player.m_6352_((Component)new TranslatableComponent("message.feywild.bell.angry"), player.m_142081_());
                        golem.m_6034_(librarian.m_20185_(), librarian.m_20186_(), librarian.m_20189_());
                        level.m_7967_((Entity)golem);
                        blockEntity.setSecurity(golem.m_142081_());
                        QuestData.get((ServerPlayer)player).checkComplete(SpecialTask.INSTANCE, SpecialTaskAction.ANNOY_LIBRARIAN);
                    } else {
                        security.m_6034_(librarian.m_20185_(), librarian.m_20186_(), librarian.m_20189_());
                        if (security instanceof Mob) {
                            ((Mob)security).m_6710_((LivingEntity)player);
                        }
                    }
                } else if (blockEntity.getAnnoyance() > 6) {
                    player.m_6352_((Component)new TranslatableComponent("message.feywild.bell.annoyed"), player.m_142081_());
                }
                if (librarian != null && librarian.m_6084_()) {
                    if (librarian instanceof Villager) {
                        ((Villager)librarian).m_35524_();
                    }
                    librarian.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                Villager entity2 = new Villager(EntityType.f_20492_, level);
                entity2.m_20049_("feywild_librarian");
                entity2.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                for (Direction dir : Direction.values()) {
                    BlockPos target;
                    if (dir.m_122434_() == Direction.Axis.Y || !level.m_8055_(target = pos.m_7495_().m_142300_(dir)).m_60795_()) continue;
                    entity2.m_6034_((double)target.m_123341_() + 0.5, (double)target.m_123342_(), (double)target.m_123343_() + 0.5);
                    break;
                }
                level.m_7967_((Entity)entity2);
                blockEntity.setLibrarian(entity2.m_142081_());
                QuestData.get((ServerPlayer)player).checkComplete(SpecialTask.INSTANCE, SpecialTaskAction.SUMMON_LIBRARIAN);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public boolean m_6724_(@Nonnull BlockState state) {
        return true;
    }

    public void m_7455_(@Nonnull BlockState state, ServerLevel level, @Nonnull BlockPos pos, @Nonnull Random random) {
        Entity security;
        LibraryBell entity = (LibraryBell)level.m_7702_(pos);
        if (entity != null && entity.getSecurity() != null && (security = level.m_8791_(entity.getSecurity())) != null) {
            entity.setDespawnTimer(entity.getDespawnTimer() + 1);
            if (entity.getDespawnTimer() >= 2) {
                entity.setDespawnTimer(0);
                security.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

