/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.trees;

import com.feywild.feywild.config.ClientConfig;
import io.github.noeppi_noeppi.libx.base.BlockBase;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class FeyLeavesBlock
extends BlockBase
implements Registerable,
IForgeShearable {
    public static final int MAX_DISTANCE = 15;
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)0, (int)15);
    public static final int MAX_PARTICLE_DISTANCE = 48;
    private final int chance;
    private final SimpleParticleType particle;

    public FeyLeavesBlock(ModX mod, int chance, SimpleParticleType particle) {
        super(mod, BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_((s, r, p, t) -> false).m_60960_((s, r, p) -> false).m_60971_((s, r, p) -> false));
        this.chance = chance;
        this.particle = particle;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61447_, (Comparable)Boolean.valueOf(false)));
    }

    public void registerCommon(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> ComposterBlock.m_51920_((float)0.4f, (ItemLike)this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> ItemBlockRenderTypes.setRenderLayer((Block)this, (RenderType)RenderType.m_110463_()));
    }

    protected static BlockState updateDistance(BlockState state, LevelAccessor levelIn, BlockPos pos) {
        int distance = 15;
        BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            if (distance <= 1) continue;
            current.m_122159_((Vec3i)pos, direction);
            distance = Math.min(distance, FeyLeavesBlock.getDistance(levelIn.m_8055_((BlockPos)current)) + 1);
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(distance));
    }

    private static int getDistance(BlockState neighbor) {
        if (BlockTags.f_13106_.m_8110_((Object)neighbor.m_60734_())) {
            return 0;
        }
        if (neighbor.m_60734_() instanceof FeyLeavesBlock) {
            return (Integer)neighbor.m_61143_((Property)DISTANCE);
        }
        return 15;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, BlockStateProperties.f_61447_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FeyLeavesBlock.updateDistance((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61447_, (Comparable)Boolean.valueOf(true)), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    @Nonnull
    public VoxelShape m_7947_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return Shapes.m_83040_();
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)DISTANCE) == 15 && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61447_) == false;
    }

    public void m_7455_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull Random random) {
        FeyLeavesBlock.updateDistance(state, (LevelAccessor)level, pos);
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61447_)).booleanValue() && (Integer)state.m_61143_((Property)DISTANCE) == 15) {
            FeyLeavesBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            level.m_7471_(pos, false);
        }
    }

    public void m_7458_(@Nonnull BlockState state, ServerLevel levelIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        levelIn.m_7731_(pos, FeyLeavesBlock.updateDistance(state, (LevelAccessor)levelIn, pos), 3);
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        int distance = FeyLeavesBlock.getDistance(facingState) + 1;
        if (distance != 1 || (Integer)state.m_61143_((Property)DISTANCE) != distance) {
            level.m_6219_().m_5945_(pos, (Object)this, 1);
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (ClientConfig.tree_particles) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91074_.m_20182_().m_82531_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) < 2304.0) {
                this.animateLeaves(state, level, pos, rand);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void animateLeaves(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(rand.nextInt(15) != 0 || !level.m_46758_(pos.m_7494_()) || (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)level, blockpos, Direction.UP))) {
            double x = (double)pos.m_123341_() + rand.nextDouble();
            double y = (double)pos.m_123342_() - 0.05;
            double z = (double)pos.m_123343_() + rand.nextDouble();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, x, y, z, 0.0, 0.0, 0.0);
        }
        if (rand.nextInt(this.chance) == 1 && level.m_46859_(pos.m_7495_())) {
            level.m_7106_((ParticleOptions)this.particle, (double)pos.m_123341_() + rand.nextDouble(), (double)pos.m_123342_(), (double)pos.m_123343_() + rand.nextDouble(), 1.0, -0.1, 0.0);
        }
    }
}

