/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.base;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.entity.base.FeyBase;
import com.feywild.feywild.entity.base.ITameable;
import com.feywild.feywild.entity.goals.FeyWildPanicGoal;
import com.feywild.feywild.entity.goals.TameCheckingGoal;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.network.quest.OpenQuestDisplaySerializer;
import com.feywild.feywild.network.quest.OpenQuestSelectionSerializer;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.QuestDisplay;
import com.feywild.feywild.quest.player.QuestData;
import com.feywild.feywild.quest.task.FeyGiftTask;
import com.feywild.feywild.quest.util.AlignmentStack;
import com.feywild.feywild.quest.util.SelectableQuest;
import io.github.noeppi_noeppi.libx.util.NBTX;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public abstract class Fey
extends FeyBase
implements ITameable {
    public static final EntityDataAccessor<Boolean> CASTING = SynchedEntityData.m_135353_(Fey.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private BlockPos currentTargetPos;
    private boolean isTamed;

    protected Fey(EntityType<? extends Fey> type, Alignment alignment, Level level) {
        super(type, alignment, level);
    }

    public static boolean canSpawn(EntityType<? extends Fey> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        return Tags.Blocks.DIRT.m_8110_((Object)level.m_8055_(pos.m_7495_()).m_60734_()) || Tags.Blocks.SAND.m_8110_((Object)level.m_8055_(pos.m_7495_()).m_60734_());
    }

    @Nullable
    public BlockPos getCurrentTargetPos() {
        return this.currentTargetPos;
    }

    public void setCurrentTargetPos(@Nullable BlockPos currentTargetPos) {
        this.currentTargetPos = currentTargetPos == null ? null : currentTargetPos.m_7949_();
    }

    @Override
    public boolean isTamed() {
        return this.isTamed;
    }

    public void setTamed(boolean tamed) {
        this.isTamed = tamed;
    }

    @Override
    @Nullable
    public Vec3 getCurrentPointOfInterest() {
        if (!this.isTamed()) {
            return null;
        }
        if (this.currentTargetPos != null) {
            return new Vec3((double)this.currentTargetPos.m_123341_() + 0.5, (double)this.currentTargetPos.m_123342_() + 0.5, (double)this.currentTargetPos.m_123343_() + 0.5);
        }
        Player player = this.getOwner();
        if (player != null) {
            return player.m_20182_();
        }
        return null;
    }

    public boolean isCasting() {
        return (Boolean)this.f_19804_.m_135370_(CASTING);
    }

    public void setCasting(boolean casting) {
        this.f_19804_.m_135381_(CASTING, (Object)casting);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CASTING, (Object)false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(50, (Goal)new FeyWildPanicGoal(this, 0.003, 13));
        this.f_21345_.m_25352_(10, (Goal)new TameCheckingGoal(this, false, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42572_}), false)));
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Tamed", this.isTamed);
        if (this.currentTargetPos != null) {
            NBTX.putPos((CompoundTag)nbt, (String)"CurrentTarget", (BlockPos)this.currentTargetPos);
        }
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.isTamed = nbt.m_128471_("Tamed");
        this.currentTargetPos = NBTX.getPos((CompoundTag)nbt, (String)"CurrentTarget", null);
    }

    @Nonnull
    public InteractionResult m_7111_(@Nonnull Player player, @Nonnull Vec3 hitVec, @Nonnull InteractionHand hand) {
        if (!this.f_19853_.f_46443_) {
            ItemStack stack;
            if (player.m_6144_()) {
                if (this.owner != null && this.owner.equals(player.m_142081_())) {
                    if (this.getCurrentTargetPos() == null) {
                        this.setCurrentTargetPos(this.m_142538_());
                        player.m_6352_((Component)new TranslatableComponent("message.feywild." + this.alignment.id + "_fey_stay").m_7220_((Component)new TranslatableComponent("message.feywild.fey_stay").m_130940_(ChatFormatting.ITALIC)), player.m_142081_());
                    } else {
                        this.setCurrentTargetPos(null);
                        player.m_6352_((Component)new TranslatableComponent("message.feywild." + this.alignment.id + "_fey_follow").m_7220_((Component)new TranslatableComponent("message.feywild.fey_follow").m_130940_(ChatFormatting.ITALIC)), player.m_142081_());
                    }
                }
            } else if (player instanceof ServerPlayer && this.tryAcceptGift((ServerPlayer)player, hand)) {
                player.m_21011_(hand, true);
            } else if (!(player.m_21120_(hand).m_41720_() != Items.f_42572_ || this.m_142581_() != null && this.m_142581_().m_6084_())) {
                this.m_5634_(4.0f);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                FeywildMod.getNetwork().sendParticles(this.f_19853_, ParticleSerializer.Type.FEY_HEART, this.m_20185_(), this.m_20186_(), this.m_20189_());
                player.m_21011_(hand, true);
            } else if (player.m_21120_(hand).m_41720_() == Items.f_42656_) {
                this.m_6593_((Component)new TextComponent(player.m_21120_(hand).m_41611_().getString().substring(1, player.m_21120_(hand).m_41611_().getString().length() - 1)));
                this.m_20340_(true);
                player.m_6352_((Component)new TranslatableComponent("message.feywild." + this.alignment.id + "_fey_name"), player.m_142081_());
            } else if (this.isTamed() && player instanceof ServerPlayer && this.owner != null && this.owner.equals(player.m_142081_()) && (stack = player.m_21120_(hand)).m_41619_()) {
                this.interactQuest((ServerPlayer)player, hand);
            }
        }
        return InteractionResult.CONSUME;
    }

    private void interactQuest(ServerPlayer player, InteractionHand hand) {
        QuestData quests = QuestData.get(player);
        if (quests.canComplete(this.alignment)) {
            QuestDisplay completionDisplay = quests.completePendingQuest();
            if (completionDisplay != null) {
                FeywildMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(completionDisplay, false));
                player.m_21011_(hand, true);
            } else {
                List<SelectableQuest> active = quests.getActiveQuests();
                if (active.size() == 1) {
                    FeywildMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(active.get((int)0).display, false));
                    player.m_21011_(hand, true);
                } else if (!active.isEmpty()) {
                    FeywildMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestSelectionSerializer.Message(this.m_5446_(), this.alignment, active));
                    player.m_21011_(hand, true);
                }
            }
        } else {
            QuestDisplay initDisplay = quests.initialize(this.alignment);
            if (initDisplay != null) {
                FeywildMod.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenQuestDisplaySerializer.Message(initDisplay, true));
                player.m_21011_(hand, true);
            }
        }
    }

    private boolean tryAcceptGift(ServerPlayer player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_()) {
            AlignmentStack input = new AlignmentStack(this.alignment, stack);
            if (QuestData.get(player).checkComplete(FeyGiftTask.INSTANCE, input)) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                player.m_6352_((Component)new TranslatableComponent("message.feywild." + this.alignment.id + "_fey_thanks"), player.m_142081_());
                return true;
            }
        }
        return false;
    }

    private <E extends IAnimatable> PlayState flyingPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.pixie.fly", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState castingPredicate(AnimationEvent<E> event) {
        if (this.isCasting() && !this.f_20890_ && !this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.pixie.spellcasting", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController flyingController = new AnimationController((IAnimatable)this, "flyingController", 0.0f, this::flyingPredicate);
        AnimationController castingController = new AnimationController((IAnimatable)this, "castingController", 0.0f, this::castingPredicate);
        animationData.addAnimationController(flyingController);
        animationData.addAnimationController(castingController);
    }
}

