/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.entity.WinterPixie;
import com.feywild.feywild.entity.base.Fey;
import com.feywild.feywild.sound.ModSoundEvents;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.phys.Vec3;

public class SummonSnowManGoal
extends Goal {
    private static final TargetingConditions TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26888_(living -> !(living instanceof Fey));
    private final Fey entity;
    private int ticksLeft = 0;
    private Vec3 targetPos;

    public SummonSnowManGoal(WinterPixie entity) {
        this.entity = entity;
    }

    public void m_8037_() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (!this.noSnowManNearby()) {
                this.reset();
                return;
            }
            if (this.ticksLeft <= 0) {
                this.summonSnowMan();
                this.reset();
            } else if (this.ticksLeft == 110) {
                this.spellCasting();
            } else if (this.ticksLeft <= 100) {
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetPos);
            }
        }
    }

    public void m_8056_() {
        this.ticksLeft = 120;
        this.entity.setCasting(false);
    }

    private void spellCasting() {
        this.targetPos = new Vec3(this.entity.m_20185_() + (double)this.entity.m_21187_().nextInt(8) - 4.0, this.entity.m_20186_() + 2.0, this.entity.m_20189_() + (double)this.entity.m_21187_().nextInt(8) - 4.0);
        this.entity.setCasting(true);
        this.entity.m_5496_(ModSoundEvents.pixieSpellcasting, 1.0f, 1.0f);
    }

    private void reset() {
        this.entity.setCasting(false);
        this.targetPos = null;
        this.ticksLeft = -1;
    }

    private void summonSnowMan() {
        SnowGolem snowman = new SnowGolem(EntityType.f_20528_, this.entity.f_19853_);
        snowman.m_6034_(this.entity.m_20185_(), this.entity.m_20186_() + 1.0, this.entity.m_20189_());
        snowman.m_20334_((this.targetPos.f_82479_ - this.entity.m_20185_()) / 8.0, (this.targetPos.f_82480_ - this.entity.m_20186_()) / 8.0, (this.targetPos.f_82481_ - this.entity.m_20189_()) / 8.0);
        this.entity.f_19853_.m_7967_((Entity)snowman);
    }

    public boolean m_8045_() {
        return this.ticksLeft > 0;
    }

    public boolean m_8036_() {
        return this.entity.isTamed() && this.entity.f_19853_.f_46441_.nextFloat() < 0.002f && this.noSnowManNearby();
    }

    private boolean noSnowManNearby() {
        return this.entity.f_19853_.m_45971_(SnowGolem.class, TARGETING, (LivingEntity)this.entity, this.entity.m_142469_().m_82400_(8.0)).isEmpty();
    }
}

