/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.entity.base.Fey;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.sound.ModSoundEvents;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;

public class TargetFireGoal
extends Goal {
    private static final TargetingConditions TARGETING = TargetingConditions.m_148352_().m_26883_(8.0).m_148355_();
    private final Fey entity;
    private Monster targetMonster;
    private int ticksLeft = 0;

    public TargetFireGoal(Fey entity) {
        this.entity = entity;
    }

    public void m_8037_() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.targetMonster == null) {
                this.targetMonster = this.findTarget();
                if (this.targetMonster == null) {
                    this.reset();
                    return;
                }
            }
            if (this.ticksLeft <= 0) {
                this.targetMonster.m_20254_(120);
                FeywildMod.getNetwork().sendParticles(this.entity.f_19853_, ParticleSerializer.Type.MONSTER_FIRE, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), this.targetMonster.m_20185_(), this.targetMonster.m_20186_(), this.targetMonster.m_20189_());
                this.reset();
            } else if (this.ticksLeft == 110) {
                this.spellCasting();
            }
        }
    }

    private void spellCasting() {
        this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetMonster.m_20182_());
        this.entity.setCasting(true);
        this.entity.m_5496_(ModSoundEvents.pixieSpellcasting, 1.0f, 1.0f);
    }

    public void m_8056_() {
        this.ticksLeft = 120;
        this.targetMonster = null;
    }

    protected void reset() {
        this.entity.setCasting(false);
        this.targetMonster = null;
        this.ticksLeft = -1;
    }

    public boolean m_8045_() {
        return this.ticksLeft > 0;
    }

    public boolean m_8036_() {
        return this.entity.isTamed() && this.entity.f_19853_.f_46441_.nextFloat() < 0.005f;
    }

    private Monster findTarget() {
        double distance = Double.MAX_VALUE;
        Monster current = null;
        for (Monster monster : this.entity.f_19853_.m_45971_(Monster.class, TARGETING, (LivingEntity)this.entity, this.entity.m_142469_().m_82400_(8.0))) {
            if (!(this.entity.m_20280_((Entity)monster) < distance) || monster.m_6060_()) continue;
            current = monster;
            distance = this.entity.m_20280_((Entity)monster);
        }
        return current;
    }
}

