/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.network;

import com.feywild.feywild.trade.recipe.TradeRecipe;
import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class TradesSerializer
implements PacketSerializer<Message> {
    public Class<Message> messageClass() {
        return Message.class;
    }

    public void encode(Message msg, FriendlyByteBuf buffer) {
        buffer.m_130130_(msg.recipes.size());
        msg.recipes.forEach(recipe -> {
            buffer.m_130085_(recipe.id);
            buffer.m_130130_(recipe.level);
            buffer.m_130130_(recipe.trades.size());
            recipe.trades.forEach(trade -> {
                buffer.m_130130_(trade.input.size());
                trade.input.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
                buffer.m_130130_(trade.additional.size());
                trade.additional.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
                buffer.m_130130_(trade.output.size());
                trade.output.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
            });
        });
    }

    public Message decode(FriendlyByteBuf buffer) {
        ImmutableList.Builder recipes = ImmutableList.builder();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buffer.m_130281_();
            int level = buffer.m_130242_();
            ImmutableList.Builder trades = ImmutableList.builder();
            int tradeSize = buffer.m_130242_();
            for (int j = 0; j < tradeSize; ++j) {
                trades.add((Object)new TradeRecipe.Entry(this.readStackList(buffer), this.readStackList(buffer), this.readStackList(buffer)));
            }
            recipes.add((Object)new TradeRecipe(id, level, (List<TradeRecipe.Entry>)trades.build()));
        }
        return new Message((List<TradeRecipe>)recipes.build());
    }

    private List<ItemStack> readStackList(FriendlyByteBuf buffer) {
        ImmutableList.Builder stacks = ImmutableList.builder();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            stacks.add((Object)buffer.m_130267_());
        }
        return stacks.build();
    }

    public static class Message {
        public final List<TradeRecipe> recipes;

        public Message(List<TradeRecipe> recipes) {
            this.recipes = recipes;
        }
    }
}

