/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.network.quest;

import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.util.SelectableQuest;
import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class OpenQuestSelectionSerializer
implements PacketSerializer<Message> {
    public Class<Message> messageClass() {
        return Message.class;
    }

    public void encode(Message msg, FriendlyByteBuf buffer) {
        buffer.m_130083_(msg.title);
        buffer.m_130068_((Enum)msg.alignment);
        buffer.m_130130_(msg.quests.size());
        for (SelectableQuest quest : msg.quests) {
            quest.toNetwork(buffer);
        }
    }

    public Message decode(FriendlyByteBuf buffer) {
        Component title = buffer.m_130238_();
        Alignment alignment = (Alignment)buffer.m_130066_(Alignment.class);
        int questSize = buffer.m_130242_();
        ImmutableList.Builder quests = ImmutableList.builder();
        for (int i = 0; i < questSize; ++i) {
            quests.add((Object)SelectableQuest.fromNetwork(buffer));
        }
        return new Message(title, alignment, (List<SelectableQuest>)quests.build());
    }

    public static class Message {
        public final Component title;
        public final Alignment alignment;
        public final List<SelectableQuest> quests;

        public Message(Component title, Alignment alignment, List<SelectableQuest> quests) {
            this.title = title;
            this.alignment = alignment;
            this.quests = ImmutableList.copyOf(quests);
        }
    }
}

