/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.quest.task;

import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.task.TaskType;
import com.feywild.feywild.quest.util.AlignmentStack;
import com.feywild.feywild.quest.util.FeyGift;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class FeyGiftTask
implements TaskType<FeyGift, AlignmentStack> {
    public static final FeyGiftTask INSTANCE = new FeyGiftTask();

    private FeyGiftTask() {
    }

    @Override
    public Class<FeyGift> element() {
        return FeyGift.class;
    }

    @Override
    public Class<AlignmentStack> testType() {
        return AlignmentStack.class;
    }

    @Override
    public boolean checkCompleted(ServerPlayer player, FeyGift element, AlignmentStack match) {
        return element.alignment == match.alignment && element.ingredient.test(match.getStack());
    }

    @Override
    public FeyGift fromJson(JsonObject json) {
        Alignment alignment = Alignment.byId(json.get("alignment").getAsString());
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("item"));
        return new FeyGift(alignment, ingredient);
    }

    @Override
    public JsonObject toJson(FeyGift element) {
        JsonObject json = new JsonObject();
        json.addProperty("alignment", element.alignment.id);
        json.add("item", element.ingredient.m_43942_());
        return json;
    }

    @Override
    @Nullable
    public Item icon(FeyGift element) {
        ItemStack[] matching = element.ingredient.m_43908_();
        if (matching.length == 1 && !matching[0].m_41619_()) {
            return matching[0].m_41720_();
        }
        return null;
    }
}

