/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.recipes;

import com.feywild.feywild.recipes.IAltarRecipe;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.feywild.feywild.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AltarRecipe
implements IAltarRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final List<Ingredient> inputs;
    private final NonNullList<Ingredient> inputList;

    public AltarRecipe(ResourceLocation id, ItemStack output, List<Ingredient> inputs) {
        this.id = id;
        this.output = output;
        this.inputs = ImmutableList.copyOf(inputs);
        this.inputList = NonNullList.m_122780_((int)this.inputs.size(), (Object)Ingredient.f_43901_);
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.inputList.set(i, (Object)this.inputs.get(i));
        }
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipeTypes.ALTAR_SERIALIZER;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputList;
    }

    @Override
    public Optional<ItemStack> getResult(List<ItemStack> inputs) {
        return Util.simpleMatch(this.inputs, inputs) ? Optional.of(this.m_8043_()) : Optional.empty();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<AltarRecipe> {
        @Nonnull
        public AltarRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (JsonElement jsonElement : ingredients) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)jsonElement));
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)true);
            return new AltarRecipe(recipeId, output, (List<Ingredient>)inputs.build());
        }

        @Nullable
        public AltarRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            int inputSize = buffer.m_130242_();
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (int i = 0; i < inputSize; ++i) {
                inputs.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new AltarRecipe(recipeId, output, (List<Ingredient>)inputs.build());
        }

        public void toNetwork(FriendlyByteBuf buffer, AltarRecipe recipe) {
            buffer.m_130130_(recipe.m_7527_().size());
            recipe.inputs.forEach(i -> i.m_43923_(buffer));
            buffer.writeItemStack(recipe.m_8043_(), false);
        }
    }
}

