/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.recipes;

import com.feywild.feywild.recipes.IDwarvenAnvilRecipe;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.feywild.feywild.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DwarvenAnvilRecipe
implements IDwarvenAnvilRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    @Nullable
    private final Ingredient schematics;
    private final List<Ingredient> inputs;
    private final NonNullList<Ingredient> inputList;
    private final int mana;

    public DwarvenAnvilRecipe(ResourceLocation id, ItemStack output, @Nullable Ingredient schematics, List<Ingredient> inputs, int mana) {
        this.id = id;
        this.output = output;
        this.schematics = schematics;
        this.inputs = ImmutableList.copyOf(inputs);
        this.inputList = NonNullList.m_122780_((int)this.inputs.size(), (Object)Ingredient.f_43901_);
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.inputList.set(i, (Object)this.inputs.get(i));
        }
        this.mana = mana;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipeTypes.DWARVEN_ANVIL_SERIALIZER;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    @Nullable
    public Ingredient getSchematics() {
        return this.schematics;
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputList;
    }

    @Override
    public Optional<ItemStack> getResult(ItemStack schematics, List<ItemStack> inputs) {
        if (this.schematics != null && (schematics.m_41619_() || !this.schematics.test(schematics))) {
            return Optional.empty();
        }
        if (!Util.simpleMatch(this.inputs, inputs)) {
            return Optional.empty();
        }
        return Optional.of(this.m_8043_());
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<DwarvenAnvilRecipe> {
        @Nonnull
        public DwarvenAnvilRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            int mana = GsonHelper.m_13927_((JsonObject)json, (String)"mana");
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)true);
            Ingredient schematics = json.has("schematics") ? Ingredient.m_43917_((JsonElement)json.get("schematics")) : null;
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement jsonElement : ingredients) {
                inputs.add(Ingredient.m_43917_((JsonElement)jsonElement));
            }
            return new DwarvenAnvilRecipe(recipeId, output, schematics, inputs, mana);
        }

        @Nullable
        public DwarvenAnvilRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int mana = buffer.m_130242_();
            Ingredient schematics = buffer.readBoolean() ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            int inputSize = buffer.m_130242_();
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (int i = 0; i < inputSize; ++i) {
                inputs.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new DwarvenAnvilRecipe(recipeId, output, schematics, (List<Ingredient>)inputs.build(), mana);
        }

        public void toNetwork(FriendlyByteBuf buffer, DwarvenAnvilRecipe recipe) {
            buffer.m_130130_(recipe.mana);
            buffer.writeBoolean(recipe.schematics != null);
            if (recipe.schematics != null) {
                recipe.schematics.m_43923_(buffer);
            }
            buffer.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(i -> i.m_43923_(buffer));
            buffer.writeItemStack(recipe.m_8043_(), false);
        }
    }
}

