/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.biome;

import com.feywild.feywild.config.CompatConfig;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.world.biome.ModBiomes;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBiomeGeneration {
    public static void setupBiomes() {
        if (CompatConfig.mythic_alfheim.overworld) {
            ModBiomeGeneration.addBiome(ModBiomes.blossomingWealds, BiomeManager.BiomeType.WARM, WorldGenConfig.biomes.spring.weight(), BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST);
            ModBiomeGeneration.addBiome(ModBiomes.goldenSeelieFields, BiomeManager.BiomeType.WARM, WorldGenConfig.biomes.summer.weight(), BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.HOT);
            ModBiomeGeneration.addBiome(ModBiomes.eternalFall, BiomeManager.BiomeType.WARM, WorldGenConfig.biomes.autumn.weight(), BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MUSHROOM);
            ModBiomeGeneration.addBiome(ModBiomes.frozenRetreat, BiomeManager.BiomeType.ICY, WorldGenConfig.biomes.winter.weight(), BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.COLD);
        }
    }

    private static void addBiome(Biome biome, BiomeManager.BiomeType type, int weight, BiomeDictionary.Type ... types) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome)));
        BiomeDictionary.addTypes((ResourceKey)key, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((ResourceKey)key, (BiomeDictionary.Type[])types);
        BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(key, weight));
    }
}

