/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.dimension.market;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.world.dimension.ModDimensions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class MarketData
extends SavedData {
    private boolean open;
    private boolean generated;

    public MarketData() {
        this.open = false;
        this.generated = false;
    }

    public MarketData(@Nonnull CompoundTag nbt) {
        this.open = nbt.m_128471_("Open");
        this.generated = nbt.m_128471_("Generated");
    }

    @Nullable
    public static MarketData get(ServerLevel level) {
        if (level.m_46472_() != ModDimensions.MARKET_PLACE_DIMENSION) {
            return null;
        }
        DimensionDataStorage storage = level.m_8895_();
        return (MarketData)storage.m_164861_(MarketData::new, MarketData::new, FeywildMod.getInstance().modid + "_market");
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        nbt.m_128379_("Open", this.open);
        nbt.m_128379_("Generated", this.generated);
        return nbt;
    }

    public boolean tryGenerate() {
        if (!this.generated) {
            this.generated = true;
            this.m_77762_();
            return true;
        }
        return false;
    }

    public void update(MinecraftServer server, Runnable onClose) {
        ServerLevel world = server.m_129783_();
        if (world.m_46461_() != this.open) {
            if (!world.m_46461_()) {
                onClose.run();
                this.generated = false;
            }
            this.open = world.m_46461_();
            this.m_77762_();
        }
    }

    public boolean isOpen() {
        return this.open;
    }
}

