/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.dimension.market;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.util.BoundingBoxUtil;
import com.feywild.feywild.world.dimension.market.MarketData;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;

public class MarketGenerator {
    public static final BlockPos BASE_POS = new BlockPos(-10, 57, -10);
    public static final List<EntityType<?>> LIVESTOCK = ImmutableList.of((Object)EntityType.f_20557_, (Object)EntityType.f_20510_, (Object)EntityType.f_20520_, (Object)EntityType.f_20457_, (Object)EntityType.f_20555_, (Object)EntityType.f_20466_);
    private static final Map<ResourceLocation, DwarfEntry> DWARVES = new HashMap<ResourceLocation, DwarfEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMarketDwarf(ResourceLocation id, EntityType<?> type, BlockPos position) {
        Map<ResourceLocation, DwarfEntry> map = DWARVES;
        synchronized (map) {
            if (DWARVES.containsKey(id)) {
                throw new IllegalStateException("Dwarf entry registered twice: " + id);
            }
            DWARVES.put(id, new DwarfEntry(type, position.m_7949_()));
        }
    }

    public static void generate(ServerLevel level) {
        MarketData data = MarketData.get(level);
        if (data != null && data.tryGenerate()) {
            MarketGenerator.generateBase(level);
            for (DwarfEntry entry : DWARVES.values()) {
                Entity entity = entry.type.m_20615_((Level)level);
                if (entity == null) continue;
                entity.m_6034_((double)entry.position.m_123341_() + 0.5, (double)entry.position.m_123342_(), (double)entry.position.m_123343_() + 0.5);
                level.m_7967_(entity);
            }
        }
    }

    private static void generateBase(ServerLevel level) {
        StructureTemplate template = level.m_8875_().m_163774_(FeywildMod.getInstance().resource("market")).orElse(null);
        if (template != null) {
            template.m_74536_((ServerLevelAccessor)level, BASE_POS, BASE_POS, new StructurePlaceSettings(), level.f_46441_, 0);
            AABB aabb = BoundingBoxUtil.get(template.m_74633_(new StructurePlaceSettings(), BASE_POS)).m_82400_(10.0);
            level.m_45933_(null, aabb).stream().filter(e -> !(e instanceof Player)).forEach(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
            for (int i = 0; i < 4; ++i) {
                MarketGenerator.addLivestock(level, -3.5, 63.0, 1.5);
            }
        }
    }

    private static void addLivestock(ServerLevel level, double x, double y, double z) {
        EntityType<?> type = LIVESTOCK.get(level.f_46441_.nextInt(LIVESTOCK.size()));
        Entity entity = type.m_20615_((Level)level);
        if (entity != null) {
            entity.m_6034_(x, y, z);
            level.m_7967_(entity);
        }
    }

    private static class DwarfEntry {
        public final EntityType<?> type;
        public final BlockPos position;

        public DwarfEntry(EntityType<?> type, BlockPos position) {
            this.type = type;
            this.position = position;
        }
    }
}

