/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.gen;

import com.feywild.feywild.block.ModBlocks;
import com.feywild.feywild.config.WorldGenConfig;
import com.feywild.feywild.config.data.OreData;
import com.feywild.feywild.world.gen.FeywildOreGen;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RangeDecoratorConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.ConfiguredDecorator;
import net.minecraft.world.level.levelgen.placement.FeatureDecorator;

public enum OreType {
    FEY_GEM_ORE(ModBlocks.feyGemBlock, ModBlocks.feyGemBlockLivingrock, () -> WorldGenConfig.ores.fey_gem);

    private final Block block;
    private final Block alfheimBlock;
    private final Supplier<OreData> data;
    private final LazyValue<ConfiguredFeature<?, ?>> feature;
    private final LazyValue<ConfiguredFeature<?, ?>> alfheimFeature;

    private OreType(Block block, Block alfheimBlock, Supplier<OreData> data) {
        this.block = block;
        this.alfheimBlock = alfheimBlock;
        this.data = data;
        this.feature = new LazyValue(() -> {
            OreConfiguration oreFeatureConfig = new OreConfiguration(OreConfiguration.Predicates.f_67854_, block.m_49966_(), this.getMaxVeinSize());
            ConfiguredDecorator configuredPlacement = (ConfiguredDecorator)((ConfiguredDecorator)FeatureDecorator.f_70692_.m_70720_((DecoratorConfiguration)new RangeDecoratorConfiguration(this.getHeight())).m_64152_()).m_64158_(this.getSpawnWeight());
            return (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)Objects.requireNonNull(block.getRegistryName()), (Object)Feature.f_65731_.m_65815_((FeatureConfiguration)oreFeatureConfig).m_7679_(configuredPlacement));
        });
        this.alfheimFeature = new LazyValue(() -> {
            OreConfiguration oreFeatureConfig = new OreConfiguration(FeywildOreGen.ALFHEIM_STONE, alfheimBlock.m_49966_(), this.getMaxVeinSize());
            ConfiguredDecorator configuredPlacement = (ConfiguredDecorator)((ConfiguredDecorator)FeatureDecorator.f_70692_.m_70720_((DecoratorConfiguration)new RangeDecoratorConfiguration(this.getHeight())).m_64152_()).m_64158_(this.getSpawnWeight());
            return (ConfiguredFeature)Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)Objects.requireNonNull(block.getRegistryName()), (Object)Feature.f_65731_.m_65815_((FeatureConfiguration)oreFeatureConfig).m_7679_(configuredPlacement));
        });
    }

    public static OreType get(Block block) {
        for (OreType ore : OreType.values()) {
            if (block != ore.block) continue;
            return ore;
        }
        return null;
    }

    public Block getBlock() {
        return this.block;
    }

    public Block getAlfheimBlock() {
        return this.alfheimBlock;
    }

    public int getMaxVeinSize() {
        return this.data.get().size();
    }

    public int getMinHeight() {
        return this.data.get().min_height();
    }

    public int getMaxHeight() {
        return this.data.get().max_height();
    }

    public int getSpawnWeight() {
        return this.data.get().weight();
    }

    public ConfiguredFeature<?, ?> getFeature() {
        return (ConfiguredFeature)this.feature.get();
    }

    public ConfiguredFeature<?, ?> getAlfheimFeature() {
        return (ConfiguredFeature)this.alfheimFeature.get();
    }

    public HeightProvider getHeight() {
        return UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)this.getMinHeight()), (VerticalAnchor)VerticalAnchor.m_158922_((int)this.getMaxHeight()));
    }

    public static void setupOres() {
        for (OreType ore : OreType.values()) {
            ore.getFeature();
        }
    }
}

