/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.structure;

import com.feywild.feywild.world.structure.structures.AutumnWorldTreeStructure;
import com.feywild.feywild.world.structure.structures.BaseStructure;
import com.feywild.feywild.world.structure.structures.BeekeepStructure;
import com.feywild.feywild.world.structure.structures.BlacksmithStructure;
import com.feywild.feywild.world.structure.structures.LibraryStructure;
import com.feywild.feywild.world.structure.structures.SpringWorldTreeStructure;
import com.feywild.feywild.world.structure.structures.SummerWorldTreeStructure;
import com.feywild.feywild.world.structure.structures.WinterWorldTreeStructure;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;

public class ModStructures {
    public static final BaseStructure springWorldTree = new SpringWorldTreeStructure();
    public static final BaseStructure summerWorldTree = new SummerWorldTreeStructure();
    public static final BaseStructure autumnWorldTree = new AutumnWorldTreeStructure();
    public static final BaseStructure winterWorldTree = new WinterWorldTreeStructure();
    public static final BaseStructure blacksmith = new BlacksmithStructure();
    public static final BaseStructure library = new LibraryStructure();
    public static final BaseStructure beekeep = new BeekeepStructure();

    public static void setupStructures() {
        ModStructures.setupMapSpacingAndLand(springWorldTree, true);
        ModStructures.setupMapSpacingAndLand(summerWorldTree, true);
        ModStructures.setupMapSpacingAndLand(autumnWorldTree, true);
        ModStructures.setupMapSpacingAndLand(winterWorldTree, true);
        ModStructures.setupMapSpacingAndLand(library, true);
        ModStructures.setupMapSpacingAndLand(blacksmith, true);
        ModStructures.setupMapSpacingAndLand(beekeep, true);
    }

    public static void setupMapSpacingAndLand(BaseStructure structure, boolean transformSurroundingLand) {
        StructureFeatureConfiguration separationSettings = structure.getSettings();
        StructureFeature.f_67012_.put((Object)Objects.requireNonNull(structure.getRegistryName()).toString(), (Object)structure);
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add((Object)structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put((Object)structure, (Object)separationSettings).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<BaseStructure, StructureFeatureConfiguration> tempMap = new HashMap<BaseStructure, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, separationSettings);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = ImmutableMap.copyOf(tempMap);
            } else {
                structureMap.put(structure, separationSettings);
            }
        });
    }
}

