/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.entity;

import com.feywild.feywild.block.DisplayGlassBlock;
import com.feywild.feywild.config.MiscConfig;
import com.feywild.feywild.item.ModItems;
import io.github.noeppi_noeppi.libx.base.tile.BlockEntityBase;
import io.github.noeppi_noeppi.libx.base.tile.TickableBlock;
import io.github.noeppi_noeppi.libx.capability.ItemCapabilities;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class DisplayGlass
extends BlockEntityBase
implements TickableBlock {
    private final BaseItemStackHandler inventory = BaseItemStackHandler.builder((int)1).contentsChanged(() -> {
        this.m_6596_();
        this.setDispatchable();
    }).build();
    private final LazyOptional<IAdvancedItemHandlerModifiable> itemHandler = ItemCapabilities.create(() -> this.inventory);
    private int generationCoolDown = 0;
    private int hitCounter = 0;

    public DisplayGlass(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (this.generationCoolDown == 0 && this.getInventory().getStackInSlot(0).m_41619_() && ((Boolean)this.m_58900_().m_61143_((Property)DisplayGlassBlock.CAN_GENERATE)).booleanValue()) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DisplayGlassBlock.BREAKAGE, (Comparable)Integer.valueOf(0)), 3);
                this.inventory.getUnrestricted().insertItem(new ItemStack((ItemLike)ModItems.honeycomb), false);
                this.generationCoolDown = -1;
            } else if (this.generationCoolDown > 0) {
                --this.generationCoolDown;
            }
            this.m_6596_();
        }
    }

    public void hitGlass() {
        if (this.f_58857_ != null) {
            ++this.hitCounter;
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11985_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (this.hitCounter > 3) {
                if ((Integer)this.m_58900_().m_61143_((Property)DisplayGlassBlock.BREAKAGE) < 4) {
                    this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DisplayGlassBlock.BREAKAGE, (Comparable)Integer.valueOf((Integer)this.m_58900_().m_61143_((Property)DisplayGlassBlock.BREAKAGE) + 1)), 3);
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.hitCounter = 0;
                }
                if ((Integer)this.m_58900_().m_61143_((Property)DisplayGlassBlock.BREAKAGE) == 4) {
                    this.generationCoolDown = MiscConfig.magical_honey_timer;
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        ItemStack stack = this.inventory.getStackInSlot(i);
                        if (stack.m_41619_()) continue;
                        ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.3, (double)this.f_58858_.m_123343_() + 0.5, stack.m_41777_());
                        this.f_58857_.m_7967_((Entity)entity);
                        this.inventory.setStackInSlot(i, ItemStack.f_41583_);
                    }
                }
            }
            this.m_6596_();
        }
    }

    @Nonnull
    public CompoundTag m_6945_(@Nonnull CompoundTag nbt) {
        nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("GenerationCoolDown", this.generationCoolDown);
        nbt.m_128405_("Hits", this.hitCounter);
        return super.m_6945_(nbt);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        this.generationCoolDown = nbt.m_128451_("GenerationCoolDown");
        this.hitCounter = nbt.m_128451_("Hits");
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        }
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        }
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }
}

