/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.render;

import com.feywild.feywild.block.entity.FeyAltar;
import com.feywild.feywild.block.model.FeyAltarModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.noeppi_noeppi.libx.render.ClientTickHandler;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoBlockRenderer;

public class FeyAltarRenderer
extends GeoBlockRenderer<FeyAltar> {
    public FeyAltarRenderer(BlockEntityRendererProvider.Context manager) {
        super(manager, (AnimatedGeoModel)new FeyAltarModel());
    }

    public void render(FeyAltar tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        super.render((BlockEntity)tile, partialTicks, poseStack, buffer, light);
        double progressScaled = (double)tile.getProgress() / 40.0;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int slot = 0; slot < tile.getInventory().getSlots(); ++slot) {
            ItemStack stack = tile.getInventory().getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
        if (!stacks.isEmpty()) {
            double anglePerStack = Math.PI * 2 / (double)stacks.size();
            for (int idx = 0; idx < stacks.size(); ++idx) {
                double shiftX = Math.cos(((double)tile.m_58904_().m_46467_() + (double)partialTicks) / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                double shiftZ = Math.sin(((double)tile.m_58904_().m_46467_() + (double)partialTicks) / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                poseStack.m_85836_();
                poseStack.m_85837_(0.5 + shiftX, 1.0 + progressScaled, 0.5 + shiftZ);
                poseStack.m_85845_(Vector3f.f_122225_.m_122270_(((float)ClientTickHandler.ticksInGame + partialTicks) / 20.0f));
                poseStack.m_85841_(0.85f, 0.85f, 0.85f);
                Minecraft.m_91087_().m_91291_().m_174269_((ItemStack)stacks.get(idx), ItemTransforms.TransformType.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, 0);
                poseStack.m_85849_();
            }
        }
    }
}

