/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.trees;

import com.feywild.feywild.block.ModBlocks;
import com.feywild.feywild.block.trees.BaseTree;
import com.feywild.feywild.block.trees.DecoratingGiantTrunkPlacer;
import com.feywild.feywild.block.trees.FeyLeavesBlock;
import com.feywild.feywild.particles.ModParticles;
import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AlterGroundDecorator;

public class AutumnTree
extends BaseTree {
    public AutumnTree(ModX mod) {
        super(mod, () -> new FeyLeavesBlock(mod, 10, ModParticles.leafParticle));
    }

    @Override
    protected TreeConfiguration.TreeConfigurationBuilder getFeatureBuilder(@Nonnull Random random, boolean largeHive) {
        return super.getFeatureBuilder(random, largeHive).m_68249_((List)ImmutableList.of((Object)new AlterGroundDecorator((BlockStateProvider)new SimpleStateProvider(Blocks.f_50599_.m_49966_()))));
    }

    protected TrunkPlacer getGiantTrunkPlacer() {
        return new TrunkPlacer(this.getBaseHeight(), this.getFirstRandomHeight(), this.getSecondRandomHeight());
    }

    @Override
    public void decorateSaplingGrowth(ServerLevel level, BlockPos pos, Random random) {
        if (random.nextDouble() < 0.2) {
            level.m_46597_(pos, AutumnTree.getDecorationBlock(random));
        }
    }

    private static BlockState getDecorationBlock(Random random) {
        return switch (random.nextInt(20)) {
            case 0 -> Blocks.f_50133_.m_49966_();
            case 1 -> Blocks.f_50143_.m_49966_();
            case 2 -> Blocks.f_50073_.m_49966_();
            case 3 -> Blocks.f_50072_.m_49966_();
            default -> Blocks.f_50035_.m_49966_();
        };
    }

    private static class TrunkPlacer
    extends DecoratingGiantTrunkPlacer {
        public TrunkPlacer(int p_i232058_1_, int p_i232058_2_, int p_i232058_3_) {
            super(p_i232058_1_, p_i232058_2_, p_i232058_3_);
        }

        @Override
        protected void decorateLog(BlockState state, WorldGenLevel level, BlockPos pos, Random random) {
            if (random.nextDouble() < 0.03) {
                if (level.m_46859_(pos.m_142127_())) {
                    level.m_7731_(pos.m_142127_(), (BlockState)ModBlocks.treeMushroom.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH), 19);
                }
                if (level.m_46859_(pos.m_142126_())) {
                    level.m_7731_(pos.m_142126_(), (BlockState)ModBlocks.treeMushroom.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST), 19);
                }
                if (level.m_46859_(pos.m_142128_())) {
                    level.m_7731_(pos.m_142128_(), (BlockState)ModBlocks.treeMushroom.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH), 19);
                }
                if (level.m_46859_(pos.m_142125_())) {
                    level.m_7731_(pos.m_142125_(), (BlockState)ModBlocks.treeMushroom.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST), 19);
                }
            }
        }
    }
}

