/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.trees;

import com.feywild.feywild.block.trees.BaseTree;
import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class BaseSaplingBlock
extends BushBlock
implements BonemealableBlock,
Registerable {
    public static final IntegerProperty STAGE = BlockStateProperties.f_61387_;
    private final BaseTree tree;
    private final BlockItem item;

    public BaseSaplingBlock(ModX mod, BaseTree tree) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_));
        this.tree = tree;
        Item.Properties properties = mod.tab == null ? new Item.Properties() : new Item.Properties().m_41491_(mod.tab);
        this.item = new BlockItem((Block)this, properties);
    }

    public Set<Object> getAdditionalRegisters(ResourceLocation id) {
        return ImmutableSet.of((Object)this.item);
    }

    public void registerCommon(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> ComposterBlock.m_51920_((float)0.4f, (ItemLike)this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> ItemBlockRenderTypes.setRenderLayer((Block)this, (RenderType)RenderType.m_110463_()));
    }

    public boolean m_7370_(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_5491_(Level level, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return (double)level.f_46441_.nextFloat() < 0.5;
    }

    public boolean m_6724_(@Nonnull BlockState state) {
        return true;
    }

    public void m_7455_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull Random rand) {
        super.m_7455_(state, level, pos, rand);
        if (level.isAreaLoaded(pos, 1) && level.m_46803_(pos.m_7494_()) >= 9 && rand.nextInt(7) == 0) {
            this.m_7719_(level, rand, pos, state);
        }
    }

    public void m_7719_(@Nonnull ServerLevel level, @Nonnull Random random, @Nonnull BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)STAGE) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)), 4);
        } else if (ForgeEventFactory.saplingGrowTree((LevelAccessor)level, (Random)random, (BlockPos)pos) && this.tree.m_6334_(level, level.m_7726_().m_8481_(), pos, state, random)) {
            for (int xd = -4; xd <= 4; ++xd) {
                block1: for (int zd = -4; zd <= 4; ++zd) {
                    for (int yd = 2; yd >= -2; --yd) {
                        BlockPos target = pos.m_142082_(xd, yd, zd);
                        if (!level.m_8055_(target).m_60795_() && !level.m_8055_(target).m_60767_().m_76336_() || !level.m_8055_(target.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) continue;
                        this.tree.decorateSaplingGrowth(level, target, random);
                        continue block1;
                    }
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAGE});
    }
}

