/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.block.trees;

import com.feywild.feywild.block.trees.BaseSaplingBlock;
import com.feywild.feywild.block.trees.FeyLeavesBlock;
import com.feywild.feywild.block.trees.FeyLogBlock;
import com.feywild.feywild.block.trees.FeyWoodBlock;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.MegaJungleTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.material.Material;

public abstract class BaseTree
extends AbstractTreeGrower
implements Registerable {
    private static final int BASE_HEIGHT = 6;
    private static final int FIRST_RANDOM_HEIGHT = 7;
    private static final int SECOND_RANDOM_HEIGHT = 8;
    private static final int LEAVES_RADIUS = 5;
    private static final int LEAVES_OFFSET = 4;
    private static final int LEAVES_HEIGHT = 5;
    private final FeyLogBlock logBlock;
    private final FeyWoodBlock woodBlock;
    private final BlockItem logItem;
    private final Registerable logRegister;
    private final FeyLeavesBlock leaves;
    private final BaseSaplingBlock sapling;

    public BaseTree(ModX mod, Supplier<? extends FeyLeavesBlock> leavesFactory) {
        this.woodBlock = new FeyWoodBlock(mod, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50014_), mod.tab == null ? new Item.Properties() : new Item.Properties().m_41491_(mod.tab));
        this.logBlock = new FeyLogBlock(this.woodBlock, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50002_));
        this.logItem = new BlockItem((Block)this.logBlock, mod.tab == null ? new Item.Properties() : new Item.Properties().m_41491_(mod.tab));
        this.logRegister = new Registerable(){

            public Set<Object> getAdditionalRegisters(ResourceLocation id) {
                return ImmutableSet.of((Object)((Object)BaseTree.this.logBlock), (Object)BaseTree.this.logItem);
            }
        };
        this.leaves = leavesFactory.get();
        this.sapling = new BaseSaplingBlock(mod, this);
    }

    public Map<String, Object> getNamedAdditionalRegisters(ResourceLocation id) {
        return ImmutableMap.of((Object)"log", (Object)this.logRegister, (Object)"wood", (Object)((Object)this.woodBlock), (Object)"leaves", (Object)((Object)this.leaves), (Object)"sapling", (Object)((Object)this.sapling));
    }

    @Nonnull
    public ConfiguredFeature<TreeConfiguration, ?> m_6486_(@Nonnull Random random, boolean largeHive) {
        TreeConfiguration featureConfig = this.getFeatureBuilder(random, largeHive).m_68251_();
        return Feature.f_65760_.m_65815_((FeatureConfiguration)featureConfig);
    }

    protected TreeConfiguration.TreeConfigurationBuilder getFeatureBuilder(@Nonnull Random random, boolean largeHive) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(this.getLogBlock().m_49966_()), this.getGiantTrunkPlacer(), (BlockStateProvider)new SimpleStateProvider(this.getLeafBlock().m_49966_()), (BlockStateProvider)new SimpleStateProvider(this.getSapling().m_49966_()), this.getFoliagePlacer(), (FeatureSize)this.getTwoLayerFeature());
    }

    protected FoliagePlacer getFoliagePlacer() {
        return new BlobFoliagePlacer((IntProvider)UniformInt.m_146622_((int)this.getLeavesRadius(), (int)this.getLeavesRadius()), (IntProvider)UniformInt.m_146622_((int)this.getLeavesOffset(), (int)this.getLeavesOffset()), this.getLeavesHeight());
    }

    protected TrunkPlacer getGiantTrunkPlacer() {
        return new MegaJungleTrunkPlacer(this.getBaseHeight(), this.getFirstRandomHeight(), this.getSecondRandomHeight());
    }

    protected TwoLayersFeatureSize getTwoLayerFeature() {
        return new TwoLayersFeatureSize(1, 0, 1);
    }

    public abstract void decorateSaplingGrowth(ServerLevel var1, BlockPos var2, Random var3);

    public FeyLogBlock getLogBlock() {
        return this.logBlock;
    }

    public FeyWoodBlock getWoodBlock() {
        return this.woodBlock;
    }

    public FeyLeavesBlock getLeafBlock() {
        return this.leaves;
    }

    public Block getSapling() {
        return this.sapling;
    }

    protected int getLeavesRadius() {
        return 5;
    }

    protected int getLeavesOffset() {
        return 4;
    }

    protected int getLeavesHeight() {
        return 5;
    }

    protected int getBaseHeight() {
        return 6;
    }

    protected int getFirstRandomHeight() {
        return 7;
    }

    protected int getSecondRandomHeight() {
        return 8;
    }

    public boolean m_6334_(@Nonnull ServerLevel level, @Nonnull ChunkGenerator generator, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Random random) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || level.m_7433_(pos.m_142082_(i, 0, j), BlockBehaviour.BlockStateBase::m_60795_) || level.m_7433_(pos.m_142082_(i, 0, j), blockState -> blockState.m_60767_().equals(Material.f_76302_))) continue;
                return false;
            }
        }
        super.m_6334_(level, generator, pos, state, random);
        return true;
    }
}

