/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.compat;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.quest.player.QuestData;
import io.github.noeppi_noeppi.mods.minemention.api.SpecialMention;
import io.github.noeppi_noeppi.mods.minemention.api.SpecialMentions;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class MineMentionCompat {
    public static void setup() {
        SpecialMentions.registerMention((ResourceLocation)FeywildMod.getInstance().resource("faction"), (String)"faction", (SpecialMention)new FactionMention());
    }

    public static void availabilityChange(ServerPlayer player) {
        SpecialMentions.notifyAvailabilityChange((ServerPlayer)player);
    }

    public static class FactionMention
    implements SpecialMention {
        public Component description() {
            return new TranslatableComponent("minemention.feywild.faction.description");
        }

        public Predicate<ServerPlayer> selectPlayers(ServerPlayer sender) {
            return player -> {
                QuestData senderData = QuestData.get(sender);
                if (senderData.getAlignment() == null) {
                    return false;
                }
                QuestData receiverData = QuestData.get(player);
                return senderData.getAlignment() == receiverData.getAlignment();
            };
        }

        public boolean available(ServerPlayer sender) {
            QuestData data = QuestData.get(sender);
            return data.getAlignment() != null;
        }
    }
}

