/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.data;

import com.feywild.feywild.block.ModTrees;
import com.feywild.feywild.item.ModItems;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.quest.Quest;
import com.feywild.feywild.quest.QuestDisplay;
import com.feywild.feywild.quest.QuestReward;
import com.feywild.feywild.quest.QuestTask;
import com.feywild.feywild.quest.reward.ItemReward;
import com.feywild.feywild.quest.task.CraftTask;
import com.feywild.feywild.quest.task.FeyGiftTask;
import com.feywild.feywild.quest.task.ItemTask;
import com.feywild.feywild.quest.task.KillTask;
import com.feywild.feywild.quest.task.SpecialTask;
import com.feywild.feywild.quest.util.FeyGift;
import com.feywild.feywild.quest.util.SpecialTaskAction;
import com.feywild.feywild.sound.ModSoundEvents;
import com.feywild.feywild.util.DatapackHelper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.github.noeppi_noeppi.libx.crafting.IngredientStack;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class QuestProvider
implements DataProvider {
    private final ModX mod;
    private final DataGenerator generator;
    private final Map<Alignment, Set<Quest>> quests = new HashMap<Alignment, Set<Quest>>();

    public QuestProvider(ModX mod, DataGenerator generator) {
        this.mod = mod;
        this.generator = generator;
    }

    public void setup() {
        this.root(Alignment.SPRING).icon((ItemLike)Items.f_42415_).reputation(25).startSound(ModSoundEvents.summoningSpringPixie).build();
        this.quest(Alignment.SPRING, "levitate_sheep").parent("root").icon((ItemLike)Blocks.f_50100_).task(QuestTask.of(SpecialTask.INSTANCE, SpecialTaskAction.LEVITATE_SHEEP, 3)).build();
        this.quest(Alignment.SPRING, "cake").parent("levitate_sheep").gift(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42502_}), 2).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)Items.f_42780_, 6))).build();
        this.quest(Alignment.SPRING, "honey").parent("cake").gift(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.honeycomb}), 1).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)ModItems.honeycomb, 1))).build();
        this.quest(Alignment.SPRING, "sapling").parent("honey").icon((ItemLike)ModTrees.springTree.getSapling()).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)ModTrees.springTree.getSapling(), 3))).build();
        this.root(Alignment.SUMMER).icon((ItemLike)Items.f_42415_).reputation(25).startSound(ModSoundEvents.summoningSummerPixie).build();
        this.quest(Alignment.SUMMER, "kill_golem").parent("root").icon((ItemLike)Items.f_42749_).task(QuestTask.of(KillTask.INSTANCE, EntityType.f_20460_)).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)Items.f_42416_, 7))).build();
        this.quest(Alignment.SUMMER, "bee_nest").reputation(20).parent("kill_golem").gift(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50717_})).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)Items.f_42784_))).build();
        this.quest(Alignment.SUMMER, "kill_pillager").parent("bee_nest").icon((ItemLike)Items.f_42386_).task(QuestTask.of(KillTask.INSTANCE, EntityType.f_20513_, 5)).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)Items.f_42417_, 3))).build();
        this.quest(Alignment.SUMMER, "sapling").parent("kill_pillager").icon((ItemLike)ModTrees.summerTree.getSapling()).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)ModTrees.summerTree.getSapling(), 3))).build();
        this.root(Alignment.AUTUMN).icon((ItemLike)Items.f_42415_).reputation(25).startSound(ModSoundEvents.summoningAutumnPixie).build();
        this.quest(Alignment.AUTUMN, "food_potatoes").parent("root").complete(null).gift(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42620_}), 9).build();
        this.quest(Alignment.AUTUMN, "food_beetroots").parent("root").complete(null).gift(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42732_}), 9).build();
        this.quest(Alignment.AUTUMN, "food_carrots").parent("root").complete(null).gift(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_}), 9).build();
        this.quest(Alignment.AUTUMN, "food_complete").parent("food_potatoes", "food_beetroots", "food_carrots").icon((ItemLike)Items.f_42734_).complete(null).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)Items.f_42734_, 1))).build();
        this.quest(Alignment.AUTUMN, "pumpkin").parent("food_complete").task(QuestTask.of(ItemTask.INSTANCE, new IngredientStack(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50143_}), 2))).build();
        this.quest(Alignment.AUTUMN, "dyes").parent("pumpkin").icon((ItemLike)Items.f_42497_).task(QuestTask.of(CraftTask.INSTANCE, Ingredient.m_43911_((Tag)Tags.Items.DYES), 9)).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)ModTrees.autumnTree.getSapling(), 3))).build();
        this.root(Alignment.WINTER).icon((ItemLike)Items.f_42415_).reputation(25).startSound(ModSoundEvents.summoningWinterPixie).build();
        this.quest(Alignment.WINTER, "snowballs").parent("root").gift(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42452_}), 16).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)Blocks.f_50126_, 4))).build();
        this.quest(Alignment.WINTER, "skull").parent("snowballs").task(QuestTask.of(ItemTask.INSTANCE, new IngredientStack(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42681_}), 1))).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)Items.f_42679_))).build();
        this.quest(Alignment.WINTER, "lantern").parent("skull").task(QuestTask.of(CraftTask.INSTANCE, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42779_}))).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)Items.f_42500_, 5))).build();
        this.quest(Alignment.WINTER, "sapling").parent("lantern").icon((ItemLike)ModTrees.winterTree.getSapling()).reward(QuestReward.of(ItemReward.INSTANCE, new ItemStack((ItemLike)ModTrees.winterTree.getSapling(), 3))).build();
    }

    public void m_6865_(@Nonnull HashCache cache) throws IOException {
        this.setup();
        for (Alignment alignment : this.quests.keySet()) {
            HashSet<ResourceLocation> ids = new HashSet<ResourceLocation>();
            for (Quest quest : this.quests.get((Object)alignment)) {
                if (ids.contains(quest.id)) {
                    throw new IllegalStateException("Duplicate quest id: " + quest.id);
                }
                ids.add(quest.id);
            }
            for (Quest quest : this.quests.get((Object)alignment)) {
                for (ResourceLocation parent : quest.parents) {
                    if (ids.contains(parent)) continue;
                    throw new IllegalStateException("Reference to unknown quest: " + parent + " (in " + quest.id + ")");
                }
                DataProvider.m_123920_((Gson)DatapackHelper.GSON, (HashCache)cache, (JsonElement)quest.toJson(), (Path)this.generator.m_123916_().resolve("data").resolve(quest.id.m_135827_()).resolve("feywild_quests").resolve(alignment.id).resolve(quest.id.m_135815_() + ".json"));
            }
        }
    }

    @Nonnull
    public String m_6055_() {
        return this.mod.modid + "quests";
    }

    public QuestBuilder root(Alignment alignment) {
        return this.quest(alignment, "root");
    }

    public QuestBuilder quest(Alignment alignment, String name) {
        return new QuestBuilder(alignment, name);
    }

    public class QuestBuilder {
        private final Alignment alignment;
        private final ResourceLocation id;
        private final Set<String> parents;
        private final List<QuestTask> tasks;
        private final List<QuestReward> rewards;
        private boolean repeatable = false;
        private int reputation;
        private Item icon;
        private QuestDisplay start;
        @Nullable
        private QuestDisplay complete;

        public QuestBuilder(Alignment alignment, String name) {
            this.alignment = alignment;
            this.id = new ResourceLocation(QuestProvider.this.mod.modid, name);
            this.parents = new HashSet<String>();
            this.reputation = 5;
            this.icon = null;
            this.start = new QuestDisplay((Component)new TranslatableComponent("quest." + QuestProvider.this.mod.modid + "." + alignment.id + "." + name + ".start.title"), (Component)new TranslatableComponent("quest." + QuestProvider.this.mod.modid + "." + alignment.id + "." + name + ".start.description"), null);
            this.complete = new QuestDisplay((Component)new TranslatableComponent("quest." + QuestProvider.this.mod.modid + "." + alignment.id + "." + name + ".complete.title"), (Component)new TranslatableComponent("quest." + QuestProvider.this.mod.modid + "." + alignment.id + "." + name + ".complete.description"), null);
            this.tasks = new ArrayList<QuestTask>();
            this.rewards = new ArrayList<QuestReward>();
        }

        public QuestBuilder parent(String ... ids) {
            this.parents.addAll(Arrays.asList(ids));
            return this;
        }

        public QuestBuilder repeatable() {
            this.repeatable = true;
            return this;
        }

        public QuestBuilder reputation(int reputation) {
            this.reputation = reputation;
            return this;
        }

        public QuestBuilder icon(ItemLike icon) {
            this.icon = icon.m_5456_();
            return this;
        }

        public QuestBuilder start(QuestDisplay display) {
            this.start = display;
            return this;
        }

        public QuestBuilder complete(@Nullable QuestDisplay display) {
            this.complete = display;
            return this;
        }

        public QuestBuilder startSound(@Nullable SoundEvent sound) {
            this.start = new QuestDisplay(this.start.title, this.start.description, sound);
            return this;
        }

        public QuestBuilder completeSound(@Nullable SoundEvent sound) {
            if (this.complete == null) {
                throw new IllegalStateException("Can't set sound on null completion.");
            }
            this.complete = new QuestDisplay(this.complete.title, this.complete.description, sound);
            return this;
        }

        public QuestBuilder task(QuestTask ... tasks) {
            this.tasks.addAll(Arrays.asList(tasks));
            return this;
        }

        public QuestBuilder gift(Ingredient ingredient) {
            return this.gift(ingredient, 1);
        }

        public QuestBuilder gift(Ingredient ingredient, int times) {
            this.tasks.add(QuestTask.of(FeyGiftTask.INSTANCE, new FeyGift(this.alignment, ingredient), times));
            return this;
        }

        public QuestBuilder reward(QuestReward ... rewards) {
            this.rewards.addAll(Arrays.asList(rewards));
            return this;
        }

        public void build() {
            Item icon = this.icon;
            if (this.icon == null && this.tasks.size() == 1) {
                icon = this.tasks.get(0).icon();
            }
            if (icon == null) {
                throw new IllegalStateException("Can't build quest without icon: " + this.id);
            }
            Set<ResourceLocation> parents = this.parents.stream().map(str -> new ResourceLocation(QuestProvider.this.mod.modid, str)).collect(Collectors.toSet());
            Quest quest = new Quest(this.id, parents, this.repeatable, this.reputation, icon, this.start, this.tasks.isEmpty() ? null : this.complete, this.tasks, this.rewards);
            QuestProvider.this.quests.computeIfAbsent(this.alignment, k -> new HashSet()).add(quest);
        }
    }
}

